/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.nickname.datamodules;

import com.google.common.base.Preconditions;
import com.google.common.reflect.TypeToken;
import io.github.nucleuspowered.nucleus.dataservices.modular.DataKey;
import io.github.nucleuspowered.nucleus.dataservices.modular.DataModule;
import io.github.nucleuspowered.nucleus.dataservices.modular.ModularUserService;
import io.github.nucleuspowered.nucleus.internal.traits.InternalServiceManagerTrait;
import io.github.nucleuspowered.nucleus.modules.nickname.services.NicknameService;
import java.util.Optional;
import javax.annotation.Nullable;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.objectmapping.ObjectMappingException;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.TextRepresentable;
import org.spongepowered.api.text.serializer.TextSerializers;

public class NicknameUserDataModule
extends DataModule.ReferenceService<ModularUserService>
implements InternalServiceManagerTrait {
    @DataKey(value="nickname-text")
    @Nullable
    private Text nickname = null;

    public NicknameUserDataModule(ModularUserService modularDataService) {
        super(modularDataService);
    }

    public Optional<Text> getNicknameAsText() {
        return Optional.ofNullable(this.nickname);
    }

    public Optional<String> getNicknameAsString() {
        return this.getNicknameAsText().map(Text::toPlain);
    }

    public void setNickname(Text nickname) {
        this.nickname = (Text)Preconditions.checkNotNull((Object)nickname);
        ((ModularUserService)this.getService()).getPlayer().ifPresent(x -> {
            Text p = this.getServiceUnchecked(NicknameService.class).getNickPrefix();
            x.offer(Keys.DISPLAY_NAME, (Object)Text.join((Text[])new Text[]{p, nickname}));
        });
    }

    public void removeNickname() {
        this.nickname = null;
        ((ModularUserService)this.getService()).getPlayer().ifPresent(x -> x.offer(Keys.DISPLAY_NAME, (Object)Text.of((String)x.getName())));
    }

    @Override
    protected <T> Optional<T> getValue(TypeToken<T> token, String path, ConfigurationNode node) {
        if (TextRepresentable.class.isAssignableFrom(token.getRawType())) {
            String str = node.getNode(new Object[]{path}).getString();
            if (str == null || str.isEmpty()) {
                return Optional.empty();
            }
            try {
                return Optional.of(TextSerializers.JSON.deserialize(str));
            }
            catch (Exception e) {
                return Optional.empty();
            }
        }
        return super.getValue(token, path, node);
    }

    @Override
    protected <T> void saveNode(TypeToken<T> typeToken, T value, String path, ConfigurationNode node) throws ObjectMappingException {
        if (value == null) {
            node.getNode(new Object[]{path}).setValue(null);
            return;
        }
        if (value instanceof TextRepresentable) {
            node.getNode(new Object[]{path}).setValue((Object)TextSerializers.JSON.serialize(((TextRepresentable)value).toText()));
            return;
        }
        super.saveNode(typeToken, value, path, node);
    }
}

