/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.powertool.commands;

import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.internal.annotations.RunAsync;
import io.github.nucleuspowered.nucleus.internal.annotations.command.NoModifiers;
import io.github.nucleuspowered.nucleus.internal.annotations.command.Permissions;
import io.github.nucleuspowered.nucleus.internal.annotations.command.RegisterCommand;
import io.github.nucleuspowered.nucleus.internal.command.AbstractCommand;
import io.github.nucleuspowered.nucleus.internal.command.ReturnMessageException;
import io.github.nucleuspowered.nucleus.modules.powertool.commands.PowertoolCommand;
import io.github.nucleuspowered.nucleus.modules.powertool.datamodules.PowertoolUserDataModule;
import java.util.List;
import java.util.Optional;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.data.type.HandTypes;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.translation.Translatable;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@Permissions(mainOverride="powertool")
@RunAsync
@NoModifiers
@NonnullByDefault
@RegisterCommand(value={"delete", "del", "rm", "remove"}, subcommandOf=PowertoolCommand.class)
public class DeletePowertoolCommand
extends AbstractCommand<Player> {
    @Override
    public CommandResult executeCommand(Player src, CommandContext args, Cause cause) throws Exception {
        ItemType item;
        Optional itemStack = src.getItemInHand(HandTypes.MAIN_HAND);
        if (!itemStack.isPresent()) {
            throw ReturnMessageException.fromKey("command.powertool.noitem", new Object[0]);
        }
        PowertoolUserDataModule user = Nucleus.getNucleus().getUserDataManager().getUnchecked((User)src).get(PowertoolUserDataModule.class);
        Optional<List<String>> cmds = user.getPowertoolForItem(item = ((ItemStack)itemStack.get()).getType());
        if (cmds.isPresent() && !cmds.get().isEmpty()) {
            user.clearPowertool(item);
            src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithTextFormat("command.powertool.removed", new Text[]{Text.of((Translatable)item, (Object[])new Object[0])}));
        } else {
            src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithTextFormat("command.powertool.nocmds", new Text[]{Text.of((Translatable)item, (Object[])new Object[0])}));
        }
        return CommandResult.success();
    }
}

