/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.powertool.commands;

import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.Util;
import io.github.nucleuspowered.nucleus.internal.annotations.RunAsync;
import io.github.nucleuspowered.nucleus.internal.annotations.command.NoModifiers;
import io.github.nucleuspowered.nucleus.internal.annotations.command.Permissions;
import io.github.nucleuspowered.nucleus.internal.annotations.command.RegisterCommand;
import io.github.nucleuspowered.nucleus.internal.command.AbstractCommand;
import io.github.nucleuspowered.nucleus.internal.messages.MessageProvider;
import io.github.nucleuspowered.nucleus.internal.userprefs.UserPreferenceService;
import io.github.nucleuspowered.nucleus.modules.powertool.PowertoolUserPreferenceKeys;
import io.github.nucleuspowered.nucleus.modules.powertool.commands.PowertoolCommand;
import io.github.nucleuspowered.nucleus.modules.powertool.datamodules.PowertoolUserDataModule;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.action.ClickAction;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.text.format.TextColor;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@Permissions(mainOverride="powertool")
@RunAsync
@NoModifiers
@RegisterCommand(value={"list", "ls"}, subcommandOf=PowertoolCommand.class)
@NonnullByDefault
public class ListPowertoolCommand
extends AbstractCommand<Player> {
    @Override
    public CommandResult executeCommand(Player src, CommandContext args, Cause cause) {
        PowertoolUserDataModule inu = Nucleus.getNucleus().getUserDataManager().getUnchecked((User)src).get(PowertoolUserDataModule.class);
        boolean toggle = ((UserPreferenceService)this.getServiceUnchecked(UserPreferenceService.class)).getUnwrapped(src.getUniqueId(), PowertoolUserPreferenceKeys.POWERTOOL_ENABLED);
        Map<String, List<String>> powertools = inu.getPowertools();
        if (powertools.isEmpty()) {
            src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.powertool.list.none", new String[0]));
            return CommandResult.success();
        }
        List mesl = powertools.entrySet().stream().sorted((a, b) -> ((String)a.getKey()).compareToIgnoreCase((String)b.getKey())).map(k -> this.from(inu, src, (String)k.getKey(), (List)k.getValue())).collect(Collectors.toList());
        Util.getPaginationBuilder((CommandSource)src).title(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.powertool.list.header", toggle ? "&aenabled" : "&cdisabled")).padding(Text.of((Object[])new Object[]{TextColors.YELLOW, "-"})).contents(mesl).sendTo((MessageReceiver)src);
        return CommandResult.success();
    }

    private Text from(PowertoolUserDataModule inu, Player src, String powertool, List<String> commands) {
        Optional oit = Sponge.getRegistry().getType(ItemType.class, powertool);
        MessageProvider mp = Nucleus.getNucleus().getMessageProvider();
        ClickAction.ExecuteCallback viewAction = TextActions.executeCallback(pl -> Util.getPaginationBuilder((CommandSource)src).title(mp.getTextMessageWithFormat("command.powertool.ind.header", powertool)).padding(Text.of((Object[])new Object[]{TextColors.GREEN, "-"})).contents((Iterable)commands.stream().map(x -> Text.of((Object[])new Object[]{TextColors.YELLOW, x})).collect(Collectors.toList())).sendTo((MessageReceiver)src));
        ClickAction.ExecuteCallback deleteAction = TextActions.executeCallback(pl -> {
            inu.clearPowertool(powertool);
            pl.sendMessage(mp.getTextMessageWithFormat("command.powertool.removed", powertool));
        });
        TextColor tc = oit.map(itemType -> TextColors.YELLOW).orElse(TextColors.GRAY);
        return Text.builder().append(new Text[]{Text.of((Object[])new Object[]{tc, powertool})}).append(new Text[]{Text.of((String)" - ")}).append(new Text[]{Text.builder((String)mp.getMessageWithFormat("standard.view", new String[0])).color(TextColors.YELLOW).onClick((ClickAction)viewAction).build()}).append(new Text[]{Text.of((String)" - ")}).append(new Text[]{Text.builder((String)mp.getMessageWithFormat("standard.delete", new String[0])).color(TextColors.DARK_RED).onClick((ClickAction)deleteAction).build()}).build();
    }
}

