/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.powertool.commands;

import com.google.common.collect.Lists;
import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.Util;
import io.github.nucleuspowered.nucleus.internal.annotations.RunAsync;
import io.github.nucleuspowered.nucleus.internal.annotations.command.NoModifiers;
import io.github.nucleuspowered.nucleus.internal.annotations.command.Permissions;
import io.github.nucleuspowered.nucleus.internal.annotations.command.RegisterCommand;
import io.github.nucleuspowered.nucleus.internal.command.AbstractCommand;
import io.github.nucleuspowered.nucleus.internal.command.NucleusParameters;
import io.github.nucleuspowered.nucleus.internal.command.ReturnMessageException;
import io.github.nucleuspowered.nucleus.internal.docgen.annotations.EssentialsEquivalent;
import io.github.nucleuspowered.nucleus.internal.messages.MessageProvider;
import io.github.nucleuspowered.nucleus.modules.powertool.datamodules.PowertoolUserDataModule;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.data.type.HandTypes;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.text.translation.Translatable;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@Permissions
@RunAsync
@NoModifiers
@RegisterCommand(value={"powertool", "pt"})
@EssentialsEquivalent(value={"powertool", "pt"})
@NonnullByDefault
public class PowertoolCommand
extends AbstractCommand<Player> {
    @Override
    public CommandElement[] getArguments() {
        return new CommandElement[]{NucleusParameters.OPTIONAL_COMMAND};
    }

    @Override
    public CommandResult executeCommand(Player src, CommandContext args, Cause cause) throws Exception {
        ItemStack itemStack = (ItemStack)src.getItemInHand(HandTypes.MAIN_HAND).orElseThrow(() -> ReturnMessageException.fromKey("command.powertool.noitem", new Object[0]));
        Optional command = args.getOne("command");
        PowertoolUserDataModule inu = Nucleus.getNucleus().getUserDataManager().getUnchecked((User)src).get(PowertoolUserDataModule.class);
        return command.map(s -> this.setPowertool(src, inu, itemStack.getType(), (String)s)).orElseGet(() -> this.viewPowertool(src, inu, itemStack));
    }

    private CommandResult viewPowertool(Player src, PowertoolUserDataModule user, ItemStack item) {
        Optional<List<String>> cmds = user.getPowertoolForItem(item.getType());
        MessageProvider mp = Nucleus.getNucleus().getMessageProvider();
        if (cmds.isPresent() && !cmds.get().isEmpty()) {
            Util.getPaginationBuilder((CommandSource)src).contents((Iterable)cmds.get().stream().map(f -> Text.of((Object[])new Object[]{TextColors.YELLOW, f})).collect(Collectors.toList())).title(mp.getTextMessageWithTextFormat("command.powertool.viewcmdstitle", new Text[]{Text.of((Translatable)item, (Object[])new Object[0]), Text.of((String)item.getType().getId())})).sendTo((MessageReceiver)src);
        } else {
            src.sendMessage(mp.getTextMessageWithTextFormat("command.powertool.nocmds", new Text[]{Text.of((Translatable)item, (Object[])new Object[0])}));
        }
        return CommandResult.success();
    }

    private CommandResult setPowertool(Player src, PowertoolUserDataModule user, ItemType item, String command) {
        if (command.startsWith("/")) {
            command = command.substring(1);
        }
        user.setPowertool(item, Lists.newArrayList((Object[])new String[]{command}));
        src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.powertool.set", item.getId(), command));
        return CommandResult.success();
    }
}

