/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.powertool.commands;

import io.github.nucleuspowered.nucleus.internal.annotations.RunAsync;
import io.github.nucleuspowered.nucleus.internal.annotations.command.NoModifiers;
import io.github.nucleuspowered.nucleus.internal.annotations.command.Permissions;
import io.github.nucleuspowered.nucleus.internal.annotations.command.RegisterCommand;
import io.github.nucleuspowered.nucleus.internal.command.AbstractCommand;
import io.github.nucleuspowered.nucleus.internal.command.NucleusParameters;
import io.github.nucleuspowered.nucleus.internal.docgen.annotations.EssentialsEquivalent;
import io.github.nucleuspowered.nucleus.internal.userprefs.UserPreferenceService;
import io.github.nucleuspowered.nucleus.modules.powertool.PowertoolUserPreferenceKeys;
import io.github.nucleuspowered.nucleus.modules.powertool.commands.PowertoolCommand;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@Permissions(mainOverride="powertool")
@RunAsync
@NoModifiers
@RegisterCommand(value={"toggle"}, subcommandOf=PowertoolCommand.class)
@NonnullByDefault
@EssentialsEquivalent(value={"powertooltoggle", "ptt", "pttoggle"})
public class TogglePowertoolCommand
extends AbstractCommand<Player> {
    @Override
    public CommandElement[] getArguments() {
        return new CommandElement[]{NucleusParameters.OPTIONAL_ONE_TRUE_FALSE};
    }

    @Override
    public CommandResult executeCommand(Player src, CommandContext args, Cause cause) {
        UserPreferenceService ups = this.getServiceManager().getServiceUnchecked(UserPreferenceService.class);
        boolean keys = ups.get(src.getUniqueId(), PowertoolUserPreferenceKeys.POWERTOOL_ENABLED).orElse(true);
        boolean toggle = args.getOne("true|false").orElse(!keys);
        ups.set(src.getUniqueId(), PowertoolUserPreferenceKeys.POWERTOOL_ENABLED, toggle);
        this.sendMessageTo((CommandSource)src, "command.powertool.toggle", new Text[]{this.getMessageFor((CommandSource)src, toggle ? "standard.enabled" : "standard.disabled")});
        return CommandResult.success();
    }
}

