/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.rtp.kernels;

import com.flowpowered.math.vector.Vector3d;
import com.flowpowered.math.vector.Vector3i;
import io.github.nucleuspowered.nucleus.Util;
import io.github.nucleuspowered.nucleus.api.rtp.RTPKernel;
import io.github.nucleuspowered.nucleus.api.service.NucleusRTPService;
import io.github.nucleuspowered.nucleus.modules.rtp.kernels.KernelHelper;
import java.util.Optional;
import javax.annotation.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockTypes;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.extent.Extent;
import org.spongepowered.api.world.teleport.TeleportHelperFilter;
import org.spongepowered.api.world.teleport.TeleportHelperFilters;

public class DefaultKernel
implements RTPKernel {
    public static final DefaultKernel INSTANCE = new DefaultKernel();

    @Override
    public Optional<Location<World>> getLocation(@Nullable Location<World> currentLocation, World target, NucleusRTPService.RTPOptions options) {
        Vector3d location;
        int count = 25;
        do {
            if (--count >= 0) continue;
            return Optional.empty();
        } while (!Util.isLocationInWorldBorder((location = KernelHelper.getLocationWithOffset(this.getCentralLocation(currentLocation, target), options)).toDouble(), target));
        Location<World> worldLocation = this.getStartingLocation((Location<World>)new Location((Extent)target, location));
        if (worldLocation == null) {
            return Optional.empty();
        }
        Optional<Location<World>> targetLocation = Sponge.getTeleportHelper().getSafeLocation(worldLocation, 3, 9, 2, TeleportHelperFilters.CONFIG, new TeleportHelperFilter[]{this.filterToUse()});
        if (targetLocation.isPresent()) {
            if (!Util.isLocationInWorldBorder(worldLocation) || options.prohibitedBiomes().contains(worldLocation.getBiome()) || options.minHeight() > worldLocation.getBlockY() || options.maxHeight() < worldLocation.getBlockY()) {
                return Optional.empty();
            }
            return this.verifyLocation((Location<World>)((Location)targetLocation.get())) ? targetLocation : Optional.empty();
        }
        return Optional.empty();
    }

    TeleportHelperFilter filterToUse() {
        return TeleportHelperFilters.DEFAULT;
    }

    Vector3i getCentralLocation(@Nullable Location<World> currentLocation, World world) {
        return world.getSpawnLocation().getBlockPosition();
    }

    @Nullable
    Location<World> getStartingLocation(Location<World> world) {
        while (world.getBlockType() == BlockTypes.AIR) {
            if (world.getY() < 1.0) {
                return null;
            }
            world = world.sub(0.0, 1.0, 0.0);
        }
        return world;
    }

    boolean verifyLocation(Location<World> world) {
        return true;
    }

    public String getId() {
        return "nucleus:default";
    }

    public String getName() {
        return "Default Kernel";
    }
}

