/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.rtp.options;

import com.google.common.base.Preconditions;
import io.github.nucleuspowered.nucleus.api.service.NucleusRTPService;
import io.github.nucleuspowered.nucleus.modules.rtp.options.RTPOptions;
import java.util.HashSet;
import java.util.Set;
import org.spongepowered.api.world.biome.BiomeType;

public class RTPOptionsBuilder
implements NucleusRTPService.RTPOptions.Builder {
    int max = 30000;
    int min = 0;
    int minheight = 1;
    int maxheight = 255;
    final Set<BiomeType> prohibitedBiomes = new HashSet<BiomeType>();

    @Override
    public NucleusRTPService.RTPOptions.Builder setMaxRadius(int max) {
        Preconditions.checkArgument((max > 0 ? 1 : 0) != 0, (Object)"Max must be positive");
        this.max = max;
        return this;
    }

    @Override
    public NucleusRTPService.RTPOptions.Builder setMinRadius(int min) {
        Preconditions.checkArgument((min >= 0 ? 1 : 0) != 0, (Object)"Min cannot be negative");
        this.min = min;
        return this;
    }

    @Override
    public NucleusRTPService.RTPOptions.Builder setMinHeight(int min) throws IllegalArgumentException {
        Preconditions.checkArgument((min >= 0 ? 1 : 0) != 0, (Object)"Min must be non-negative");
        this.minheight = min;
        return this;
    }

    @Override
    public NucleusRTPService.RTPOptions.Builder setMaxHeight(int max) throws IllegalArgumentException {
        Preconditions.checkArgument((this.min <= 255 ? 1 : 0) != 0, (Object)"Max must be less than 255");
        this.maxheight = max;
        return this;
    }

    @Override
    public NucleusRTPService.RTPOptions.Builder prohibitedBiome(BiomeType biomeType) {
        this.prohibitedBiomes.add((BiomeType)Preconditions.checkNotNull((Object)biomeType));
        return this;
    }

    @Override
    public NucleusRTPService.RTPOptions.Builder from(NucleusRTPService.RTPOptions options) {
        return this.setMinRadius(options.minRadius()).setMaxRadius(options.maxRadius()).setMaxHeight(options.maxHeight()).setMinHeight(options.minHeight());
    }

    @Override
    public NucleusRTPService.RTPOptions build() {
        Preconditions.checkState((this.min < this.max ? 1 : 0) != 0, (Object)"Minimum is bigger than maximum");
        Preconditions.checkState((this.minheight < this.maxheight ? 1 : 0) != 0, (Object)"Minimum height is bigger than maximum height");
        return new RTPOptions(this);
    }

    @Override
    public NucleusRTPService.RTPOptions.Builder reset() {
        this.max = 30000;
        this.min = 0;
        this.minheight = 1;
        this.maxheight = 255;
        this.prohibitedBiomes.clear();
        return this;
    }
}

