/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.spawn.helpers;

import com.flowpowered.math.vector.Vector3d;
import com.google.common.base.Preconditions;
import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.internal.command.ReturnMessageException;
import io.github.nucleuspowered.nucleus.modules.spawn.datamodules.SpawnWorldDataModule;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.Transform;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.extent.Extent;
import org.spongepowered.api.world.storage.WorldProperties;

public final class SpawnHelper {
    private SpawnHelper() {
    }

    public static Transform<World> getSpawn(@Nonnull WorldProperties wp, @Nullable Player player) throws ReturnMessageException {
        Preconditions.checkNotNull((Object)wp, (Object)"WorldProperties");
        Optional ow = Sponge.getServer().getWorld(wp.getUniqueId());
        if (!ow.isPresent()) {
            throw new ReturnMessageException(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.spawn.noworld", new String[0]));
        }
        return new Transform((Extent)ow.get(), wp.getSpawnPosition().toDouble().add(0.5, 0.0, 0.5), Nucleus.getNucleus().getWorldDataManager().getWorld(wp.getUniqueId()).get().get(SpawnWorldDataModule.class).getSpawnRotation().orElseGet(() -> player == null ? new Vector3d(0.0f, 0.0f, 0.0f) : player.getRotation()));
    }
}

