/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.staffchat;

import com.google.common.base.Preconditions;
import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.api.chat.NucleusChatChannel;
import io.github.nucleuspowered.nucleus.internal.text.NucleusTextTemplateImpl;
import io.github.nucleuspowered.nucleus.internal.traits.PermissionTrait;
import io.github.nucleuspowered.nucleus.modules.staffchat.commands.StaffChatCommand;
import io.github.nucleuspowered.nucleus.modules.staffchat.config.StaffChatConfig;
import io.github.nucleuspowered.nucleus.modules.staffchat.config.StaffChatConfigAdapter;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.source.ProxySource;
import org.spongepowered.api.service.context.Context;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.service.permission.SubjectCollection;
import org.spongepowered.api.service.permission.SubjectData;
import org.spongepowered.api.service.permission.SubjectReference;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.channel.MessageChannel;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.text.chat.ChatType;
import org.spongepowered.api.text.format.TextColor;
import org.spongepowered.api.util.Tristate;
import org.spongepowered.api.util.annotation.NonnullByDefault;

public class StaffChatMessageChannel
implements NucleusChatChannel.StaffChat,
PermissionTrait {
    private static StaffChatMessageChannel INSTANCE = null;
    private boolean formatting = false;
    private final String basePerm;
    private NucleusTextTemplateImpl template;
    private TextColor colour;

    public static StaffChatMessageChannel getInstance() {
        Preconditions.checkState((INSTANCE != null ? 1 : 0) != 0, (Object)"StaffChatMessageChannel#Instance");
        return INSTANCE;
    }

    StaffChatMessageChannel() {
        Nucleus.getNucleus().registerReloadable(this::onReload);
        this.onReload();
        this.basePerm = Nucleus.getNucleus().getPermissionRegistry().getPermissionsForNucleusCommand(StaffChatCommand.class).getBase();
        INSTANCE = this;
    }

    public void send(@Nullable Object sender, Text original, ChatType type) {
        Object source = !(sender instanceof CommandSource) ? (sender instanceof String ? new NamedSource((String)sender) : Sponge.getServer().getConsole()) : (CommandSource)sender;
        Text prefix = this.template.getForCommandSource((CommandSource)source);
        NucleusChatChannel.StaffChat.super.send(sender, Text.of((Object[])new Object[]{prefix, this.colour, original}), type);
    }

    @Nonnull
    public Collection<MessageReceiver> getMembers() {
        List<MessageReceiver> c = Sponge.getServer().getOnlinePlayers().stream().filter(x -> this.hasPermission((Subject)x, this.basePerm)).collect(Collectors.toList());
        c.add((MessageReceiver)Sponge.getServer().getConsole());
        return c;
    }

    @Override
    public boolean formatMessages() {
        return this.formatting;
    }

    private void onReload() {
        Nucleus.getNucleus().getConfigAdapter("staff-chat", StaffChatConfigAdapter.class).ifPresent(x -> {
            this.formatting = ((StaffChatConfig)x.getNodeOrDefault()).isIncludeStandardChatFormatting();
            this.template = ((StaffChatConfig)x.getNodeOrDefault()).getMessageTemplate();
            this.colour = ((StaffChatConfig)x.getNodeOrDefault()).getColour();
        });
    }

    @NonnullByDefault
    private class NamedSource
    implements ProxySource {
        private final String name;

        NamedSource(String name) {
            this.name = name;
        }

        public CommandSource getOriginalSource() {
            return Sponge.getServer().getConsole();
        }

        public String getName() {
            return this.name;
        }

        public Optional<CommandSource> getCommandSource() {
            return Optional.of(this.getOriginalSource());
        }

        public SubjectCollection getContainingCollection() {
            return this.getOriginalSource().getContainingCollection();
        }

        public SubjectReference asSubjectReference() {
            return this.getOriginalSource().asSubjectReference();
        }

        public boolean isSubjectDataPersisted() {
            return this.getOriginalSource().isSubjectDataPersisted();
        }

        public SubjectData getSubjectData() {
            return this.getOriginalSource().getSubjectData();
        }

        public SubjectData getTransientSubjectData() {
            return this.getOriginalSource().getTransientSubjectData();
        }

        public Tristate getPermissionValue(Set<Context> contexts, String permission) {
            return this.getOriginalSource().getPermissionValue(contexts, permission);
        }

        public boolean isChildOf(Set<Context> contexts, SubjectReference parent) {
            return this.getOriginalSource().isChildOf(contexts, parent);
        }

        public List<SubjectReference> getParents(Set<Context> contexts) {
            return this.getOriginalSource().getParents();
        }

        public Optional<String> getOption(Set<Context> contexts, String key) {
            return this.getOriginalSource().getOption(contexts, key);
        }

        public String getIdentifier() {
            return this.getName();
        }

        public Set<Context> getActiveContexts() {
            return this.getOriginalSource().getActiveContexts();
        }

        public void sendMessage(Text message) {
            this.getOriginalSource().sendMessage(message);
        }

        public MessageChannel getMessageChannel() {
            return this.getOriginalSource().getMessageChannel();
        }

        public void setMessageChannel(MessageChannel channel) {
            this.getOriginalSource().setMessageChannel(channel);
        }
    }
}

