/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.vanish.commands;

import io.github.nucleuspowered.nucleus.internal.annotations.RunAsync;
import io.github.nucleuspowered.nucleus.internal.annotations.command.NoModifiers;
import io.github.nucleuspowered.nucleus.internal.annotations.command.Permissions;
import io.github.nucleuspowered.nucleus.internal.annotations.command.RegisterCommand;
import io.github.nucleuspowered.nucleus.internal.command.AbstractCommand;
import io.github.nucleuspowered.nucleus.internal.command.NucleusParameters;
import io.github.nucleuspowered.nucleus.internal.userprefs.UserPreferenceService;
import io.github.nucleuspowered.nucleus.modules.vanish.VanishUserPrefKeys;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@Permissions(value={"nucleus.vanish.onlogin"})
@RunAsync
@NoModifiers
@RegisterCommand(value={"vanishonlogin", "vonlogin"})
@NonnullByDefault
public class ToggleVanishOnLoginCommand
extends AbstractCommand<Player> {
    @Override
    public CommandElement[] getArguments() {
        return new CommandElement[]{NucleusParameters.OPTIONAL_ONE_TRUE_FALSE};
    }

    @Override
    public CommandResult executeCommand(Player src, CommandContext args, Cause cause) {
        UserPreferenceService ups = this.getServiceManager().getServiceUnchecked(UserPreferenceService.class);
        boolean keys = ups.get(src.getUniqueId(), VanishUserPrefKeys.VANISH_ON_LOGIN).orElse(true);
        boolean toggle = args.getOne("true|false").orElse(!keys);
        ups.set(src.getUniqueId(), VanishUserPrefKeys.VANISH_ON_LOGIN, toggle);
        this.sendMessageTo((CommandSource)src, "command.vanishonlogin.toggle", new Text[]{this.getMessageFor((CommandSource)src, toggle ? "standard.enabled" : "standard.disabled")});
        return CommandResult.success();
    }
}

