/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.vanish.listener;

import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.internal.interfaces.ListenerBase;
import io.github.nucleuspowered.nucleus.internal.interfaces.Reloadable;
import io.github.nucleuspowered.nucleus.internal.userprefs.UserPreferenceService;
import io.github.nucleuspowered.nucleus.modules.vanish.VanishUserPrefKeys;
import io.github.nucleuspowered.nucleus.modules.vanish.commands.VanishCommand;
import io.github.nucleuspowered.nucleus.modules.vanish.config.VanishConfig;
import io.github.nucleuspowered.nucleus.modules.vanish.config.VanishConfigAdapter;
import io.github.nucleuspowered.nucleus.modules.vanish.datamodules.VanishUserDataModule;
import io.github.nucleuspowered.nucleus.modules.vanish.services.VanishService;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.filter.Getter;
import org.spongepowered.api.event.network.ClientConnectionEvent;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.text.action.ClickAction;
import org.spongepowered.api.text.action.TextActions;

public class VanishListener
implements Reloadable,
ListenerBase {
    private VanishConfig vanishConfig = new VanishConfig();
    private VanishService service = this.getServiceUnchecked(VanishService.class);
    private final String permission = this.getPermissionHandlerFor(VanishCommand.class).getPermissionWithSuffix("persist");
    public static final String LOGIN_VANISH_PERMISSION = "nucleus.vanish.onlogin";

    @Listener
    public void onLogin(ClientConnectionEvent.Join event, @Getter(value="getTargetEntity") Player player) {
        boolean shouldVanish;
        boolean persist = this.service.isVanished(player);
        boolean bl = shouldVanish = this.hasPermission((Subject)player, LOGIN_VANISH_PERMISSION) && this.getServiceUnchecked(UserPreferenceService.class).get(player.getUniqueId(), VanishUserPrefKeys.VANISH_ON_LOGIN).orElse(false) != false || persist;
        if (shouldVanish) {
            if (!this.hasPermission((Subject)player, this.permission)) {
                this.service.unvanishPlayer(player);
                return;
            }
            if (this.vanishConfig.isSuppressMessagesOnVanish()) {
                event.setMessageCancelled(true);
            }
            this.service.vanishPlayer(player, true);
            this.sendMessageTo((CommandSource)player, "vanish.login");
            if (!persist) {
                player.sendMessage(this.getMessageFor((CommandSource)player, "vanish.onlogin.prefs").toBuilder().onClick((ClickAction)TextActions.runCommand((String)"/nuserprefs vanish-on-login false")).build());
            }
        }
    }

    @Listener
    public void onQuit(ClientConnectionEvent.Disconnect event, @Getter(value="getTargetEntity") Player player) {
        if (player.get(Keys.VANISH).orElse(false).booleanValue()) {
            Nucleus.getNucleus().getUserDataManager().getUnchecked((User)player).get(VanishUserDataModule.class).setVanished(true);
            if (this.vanishConfig.isSuppressMessagesOnVanish()) {
                event.setMessageCancelled(true);
            }
        }
    }

    @Override
    public void onReload() {
        this.vanishConfig = (VanishConfig)this.getServiceUnchecked(VanishConfigAdapter.class).getNodeOrDefault();
    }
}

