/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.warn.commands;

import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.internal.annotations.RunAsync;
import io.github.nucleuspowered.nucleus.internal.annotations.command.NoModifiers;
import io.github.nucleuspowered.nucleus.internal.annotations.command.Permissions;
import io.github.nucleuspowered.nucleus.internal.annotations.command.RegisterCommand;
import io.github.nucleuspowered.nucleus.internal.command.AbstractCommand;
import io.github.nucleuspowered.nucleus.internal.permissions.SuggestedLevel;
import io.github.nucleuspowered.nucleus.modules.warn.data.WarnData;
import io.github.nucleuspowered.nucleus.modules.warn.services.WarnHandler;
import io.github.nucleuspowered.nucleus.util.CauseStackHelper;
import java.util.List;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@Permissions(suggestedLevel=SuggestedLevel.ADMIN)
@RunAsync
@NoModifiers
@RegisterCommand(value={"clearwarnings", "removeallwarnings"})
@NonnullByDefault
public class ClearWarningsCommand
extends AbstractCommand<CommandSource> {
    private final WarnHandler handler = (WarnHandler)this.getServiceUnchecked(WarnHandler.class);
    private final String playerKey = "subject";

    @Override
    public CommandElement[] getArguments() {
        return new CommandElement[]{GenericArguments.flags().flag(new String[]{"-all", "a"}).flag(new String[]{"-remove", "r"}).flag(new String[]{"-expired", "e"}).buildWith(GenericArguments.onlyOne((CommandElement)GenericArguments.user((Text)Text.of((String)this.playerKey))))};
    }

    @Override
    public CommandResult executeCommand(CommandSource src, CommandContext args, Cause cause) {
        User user = (User)args.getOne(this.playerKey).get();
        List<WarnData> warnings = this.handler.getWarningsInternal(user);
        if (warnings.isEmpty()) {
            src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.checkwarnings.none", user.getName()));
            return CommandResult.success();
        }
        boolean removeActive = false;
        boolean removeExpired = false;
        Text message = Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.clearwarnings.success", user.getName());
        if (args.hasAny("all")) {
            removeActive = true;
            removeExpired = true;
            message = Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.clearwarnings.all", user.getName());
        } else if (args.hasAny("remove")) {
            removeActive = true;
            message = Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.clearwarnings.remove", user.getName());
        } else if (args.hasAny("expired")) {
            removeExpired = true;
            message = Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.clearwarnings.expired", user.getName());
        }
        if (this.handler.clearWarnings(user, removeActive, removeExpired, CauseStackHelper.createCause(src))) {
            src.sendMessage(message);
            return CommandResult.success();
        }
        src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.clearwarnings.failure", user.getName()));
        return CommandResult.empty();
    }
}

