/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.world.commands;

import com.flowpowered.math.vector.Vector3d;
import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.internal.annotations.command.Permissions;
import io.github.nucleuspowered.nucleus.internal.annotations.command.RegisterCommand;
import io.github.nucleuspowered.nucleus.internal.command.AbstractCommand;
import io.github.nucleuspowered.nucleus.internal.command.NucleusParameters;
import io.github.nucleuspowered.nucleus.internal.command.ReturnMessageException;
import io.github.nucleuspowered.nucleus.internal.docgen.annotations.EssentialsEquivalent;
import io.github.nucleuspowered.nucleus.internal.permissions.PermissionInformation;
import io.github.nucleuspowered.nucleus.internal.permissions.SuggestedLevel;
import io.github.nucleuspowered.nucleus.modules.spawn.datamodules.SpawnWorldDataModule;
import io.github.nucleuspowered.nucleus.modules.world.commands.WorldCommand;
import java.util.HashMap;
import java.util.Map;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.entity.Transform;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.extent.Extent;
import org.spongepowered.api.world.storage.WorldProperties;

@Permissions(prefix="world", suggestedLevel=SuggestedLevel.ADMIN)
@RegisterCommand(value={"teleport", "tp"}, subcommandOf=WorldCommand.class)
@EssentialsEquivalent(value={"world"}, notes="The world command in Essentials was just a warp command.")
public class TeleportWorldCommand
extends AbstractCommand<CommandSource> {
    @Override
    protected Map<String, PermissionInformation> permissionSuffixesToRegister() {
        return new HashMap<String, PermissionInformation>(){
            {
                this.put("others", PermissionInformation.getWithTranslation("permission.world.teleport.other", SuggestedLevel.ADMIN));
            }
        };
    }

    @Override
    public CommandElement[] getArguments() {
        return new CommandElement[]{NucleusParameters.WORLD_PROPERTIES_ENABLED_ONLY, GenericArguments.optional((CommandElement)this.requirePermissionArg(NucleusParameters.ONE_PLAYER, this.permissions.getPermissionWithSuffix("others")))};
    }

    @Override
    public CommandResult executeCommand(CommandSource src, CommandContext args, Cause cause) throws Exception {
        Vector3d pos;
        Player player = this.getUserFromArgs(Player.class, src, "player", args, "command.world.player");
        WorldProperties worldProperties = (WorldProperties)args.getOne("world").get();
        if (!worldProperties.isEnabled()) {
            throw new ReturnMessageException(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.world.teleport.notenabled", worldProperties.getWorldName()));
        }
        World world = (World)Sponge.getServer().loadWorld(worldProperties.getUniqueId()).orElseThrow(() -> ReturnMessageException.fromKey("command.world.teleport.failed", worldProperties.getWorldName()));
        if (!player.transferToWorld(world, pos = worldProperties.getSpawnPosition().toDouble())) {
            throw ReturnMessageException.fromKey("command.world.teleport.failed", worldProperties.getWorldName());
        }
        Nucleus.getNucleus().getWorldDataManager().getWorld(worldProperties.getUniqueId()).ifPresent(x -> x.get(SpawnWorldDataModule.class).getSpawnRotation().ifPresent(y -> new Transform((Extent)world, pos, y)));
        if (src instanceof Player && ((Player)src).getUniqueId().equals(player.getUniqueId())) {
            src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.world.teleport.success", worldProperties.getWorldName()));
        } else {
            src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.world.teleport.successplayer", Nucleus.getNucleus().getNameUtil().getSerialisedName((User)player), worldProperties.getWorldName()));
            player.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.world.teleport.success", worldProperties.getWorldName()));
        }
        return CommandResult.success();
    }
}

