/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.relocate.uk.co.drnaylor.quickstart;

import com.google.common.base.Preconditions;
import io.github.nucleuspowered.relocate.uk.co.drnaylor.quickstart.LoggerProxy;
import io.github.nucleuspowered.relocate.uk.co.drnaylor.quickstart.Module;
import io.github.nucleuspowered.relocate.uk.co.drnaylor.quickstart.ModuleSpec;
import io.github.nucleuspowered.relocate.uk.co.drnaylor.quickstart.config.AbstractAdaptableConfig;
import io.github.nucleuspowered.relocate.uk.co.drnaylor.quickstart.config.ModulesConfigAdapter;
import io.github.nucleuspowered.relocate.uk.co.drnaylor.quickstart.enums.LoadingStatus;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.ConfigurationOptions;
import ninja.leaping.configurate.loader.ConfigurationLoader;

public final class SystemConfig<N extends ConfigurationNode, T extends ConfigurationLoader<N>>
extends AbstractAdaptableConfig<N, T> {
    private final LoggerProxy proxy;
    private ModulesConfigAdapter configAdapter;

    SystemConfig(T loader, LoggerProxy proxy, Function<ConfigurationOptions, ConfigurationOptions> optionsTransformer) throws IOException {
        super(loader, () -> loader.createEmptyNode((ConfigurationOptions)optionsTransformer.apply(loader.getDefaultOptions())), optionsTransformer);
        this.proxy = proxy;
    }

    void attachModulesConfig(List<ModuleSpec> defaults, Function<Class<? extends Module>, String> description, String modulesNode, @Nullable String descriptionForModules) throws IOException {
        Preconditions.checkNotNull(defaults);
        Preconditions.checkState((this.configAdapter == null ? 1 : 0) != 0);
        Map<String, LoadingStatus> msls = defaults.stream().collect(Collectors.toMap(k -> k.getId().toLowerCase(), ModuleSpec::getStatus));
        Map<String, String> msdesc = defaults.stream().collect(Collectors.toMap(k -> k.getId().toLowerCase(), k -> (String)description.apply(k.getModuleClass())));
        this.configAdapter = new ModulesConfigAdapter(msls, msdesc, this.proxy, modulesNode, descriptionForModules);
        this.attachConfigAdapter(modulesNode, this.configAdapter, descriptionForModules);
    }

    public ModulesConfigAdapter getConfigAdapter() {
        return this.configAdapter;
    }
}

