/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.relocate.uk.co.drnaylor.quickstart.modulecontainers;

import com.google.common.base.Preconditions;
import io.github.nucleuspowered.relocate.uk.co.drnaylor.quickstart.LoggerProxy;
import io.github.nucleuspowered.relocate.uk.co.drnaylor.quickstart.Module;
import io.github.nucleuspowered.relocate.uk.co.drnaylor.quickstart.ModuleContainer;
import io.github.nucleuspowered.relocate.uk.co.drnaylor.quickstart.ModuleSpec;
import io.github.nucleuspowered.relocate.uk.co.drnaylor.quickstart.Procedure;
import io.github.nucleuspowered.relocate.uk.co.drnaylor.quickstart.exceptions.NoModuleException;
import io.github.nucleuspowered.relocate.uk.co.drnaylor.quickstart.exceptions.QuickStartModuleDiscoveryException;
import io.github.nucleuspowered.relocate.uk.co.drnaylor.quickstart.loaders.ModuleEnabler;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.ConfigurationOptions;
import ninja.leaping.configurate.loader.ConfigurationLoader;

public final class ProvidedModuleContainer
extends ModuleContainer {
    private final Map<Class<? extends Module>, Module> moduleMap;

    public static Builder builder() {
        return new Builder();
    }

    private <N extends ConfigurationNode> ProvidedModuleContainer(ConfigurationLoader<N> configurationLoader, LoggerProxy loggerProxy, ModuleEnabler moduleEnabler, Procedure onPreEnable, Procedure onEnable, Procedure onPostEnable, Set<Module> modules, Function<ConfigurationOptions, ConfigurationOptions> function, boolean requireAnnotation, boolean processDoNotMerge, @Nullable Function<Module, String> headerProcessor, @Nullable Function<Class<? extends Module>, String> descriptionProcessor, String moduleSection, @Nullable String moduleSectionHeader) throws QuickStartModuleDiscoveryException {
        super(configurationLoader, loggerProxy, moduleEnabler, onPreEnable, onEnable, onPostEnable, function, requireAnnotation, processDoNotMerge, headerProcessor, descriptionProcessor, moduleSection, moduleSectionHeader);
        this.moduleMap = modules.stream().collect(Collectors.toMap(Object::getClass, v -> v));
    }

    @Override
    protected Set<Class<? extends Module>> discoverModules() throws Exception {
        return this.moduleMap.keySet();
    }

    @Override
    protected Module getModule(ModuleSpec spec) throws Exception {
        Module module = this.moduleMap.get(spec.getModuleClass());
        if (module == null) {
            throw new NoModuleException(spec.getName());
        }
        return module;
    }

    public static class Builder
    extends ModuleContainer.Builder<ProvidedModuleContainer, Builder> {
        private Set<Module> modules;

        public Builder setModules(Set<Module> modules) {
            Preconditions.checkNotNull(modules);
            Preconditions.checkArgument((!modules.isEmpty() ? 1 : 0) != 0);
            this.modules = modules;
            return this;
        }

        @Override
        protected Builder getThis() {
            return this;
        }

        @Override
        public ProvidedModuleContainer build() throws Exception {
            Preconditions.checkNotNull(this.modules);
            Preconditions.checkState((!this.modules.isEmpty() ? 1 : 0) != 0);
            this.checkBuild();
            return new ProvidedModuleContainer(this.configurationLoader, this.loggerProxy, this.enabler, this.onPreEnable, this.onEnable, this.onPostEnable, this.modules, this.configurationOptionsTransformer, this.requireAnnotation, this.doNotMerge, this.moduleConfigurationHeader, this.moduleDescriptionHandler, this.moduleConfigSection, this.moduleDescription);
        }
    }
}

