/*
 * Decompiled with CFR 0.152.
 */
package com.mcsimonflash.sponge.cmdcontrol.teslalibs.argument.parser;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mcsimonflash.sponge.cmdcontrol.teslalibs.argument.parser.StandardParser;
import java.util.Map;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.ArgumentParseException;
import org.spongepowered.api.command.args.CommandArgs;
import org.spongepowered.api.command.args.CommandContext;

public class ChoicesParser<T>
extends StandardParser<T> {
    private final Map<String, T> choices;

    public ChoicesParser(Map<String, T> choices, ImmutableMap<String, String> messages) {
        super(messages);
        this.choices = choices;
    }

    @Override
    public T parseValue(CommandSource src, CommandArgs args) throws ArgumentParseException {
        String arg = args.next();
        T value = this.choices.get(arg.toLowerCase());
        if (value != null) {
            return value;
        }
        throw args.createError(this.getMessage("no-choice", "Input <arg> is not a valid choice.", "arg", arg));
    }

    @Override
    public ImmutableList<String> complete(CommandSource src, CommandArgs args, CommandContext ctx) {
        return ChoicesParser.complete(args, this.choices.keySet().stream());
    }
}

