/*
 * Decompiled with CFR 0.152.
 */
package baubles.common.event;

import baubles.api.BaublesApi;
import baubles.api.IBauble;
import baubles.api.cap.BaublesCapabilities;
import baubles.api.cap.BaublesContainer;
import baubles.api.cap.BaublesContainerProvider;
import baubles.api.cap.IBaublesItemHandler;
import baubles.common.Baubles;
import baubles.common.network.PacketHandler;
import baubles.common.network.PacketSync;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.PlayerDropsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class EventHandlerEntity {
    private HashMap<UUID, ItemStack[]> baublesSync = new HashMap();

    @SubscribeEvent
    public void cloneCapabilitiesEvent(PlayerEvent.Clone event) {
        try {
            BaublesContainer bco = (BaublesContainer)BaublesApi.getBaublesHandler(event.getOriginal());
            NBTTagCompound nbt = bco.serializeNBT();
            BaublesContainer bcn = (BaublesContainer)BaublesApi.getBaublesHandler(event.getEntityPlayer());
            bcn.deserializeNBT(nbt);
        }
        catch (Exception e) {
            Baubles.log.error("Could not clone player [" + event.getOriginal().func_70005_c_() + "] baubles when changing dimensions");
        }
    }

    @SubscribeEvent
    public void attachCapabilitiesPlayer(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof EntityPlayer) {
            event.addCapability(new ResourceLocation("baubles", "container"), (ICapabilityProvider)new BaublesContainerProvider(new BaublesContainer()));
        }
    }

    @SubscribeEvent
    public void playerJoin(EntityJoinWorldEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)entity;
            this.syncSlots((EntityPlayer)player, Collections.singletonList(player));
        }
    }

    @SubscribeEvent
    public void onStartTracking(PlayerEvent.StartTracking event) {
        Entity target = event.getTarget();
        if (target instanceof EntityPlayerMP) {
            this.syncSlots((EntityPlayer)target, Collections.singletonList(event.getEntityPlayer()));
        }
    }

    @SubscribeEvent
    public void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        this.baublesSync.remove(event.player.func_110124_au());
    }

    @SubscribeEvent
    public void playerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            EntityPlayer player = event.player;
            IBaublesItemHandler baubles = BaublesApi.getBaublesHandler(player);
            for (int i = 0; i < baubles.getSlots(); ++i) {
                ItemStack stack = baubles.getStackInSlot(i);
                IBauble bauble = (IBauble)stack.getCapability(BaublesCapabilities.CAPABILITY_ITEM_BAUBLE, null);
                if (bauble == null) continue;
                bauble.onWornTick(stack, (EntityLivingBase)player);
            }
            if (!player.field_70170_p.field_72995_K) {
                this.syncBaubles(player, baubles);
            }
        }
    }

    private void syncBaubles(EntityPlayer player, IBaublesItemHandler baubles) {
        Object[] items = this.baublesSync.get(player.func_110124_au());
        if (items == null) {
            items = new ItemStack[baubles.getSlots()];
            Arrays.fill(items, ItemStack.field_190927_a);
            this.baublesSync.put(player.func_110124_au(), (ItemStack[])items);
        }
        if (items.length != baubles.getSlots()) {
            Object[] old = items;
            items = new ItemStack[baubles.getSlots()];
            System.arraycopy(old, 0, items, 0, Math.min(old.length, items.length));
            this.baublesSync.put(player.func_110124_au(), (ItemStack[])items);
        }
        HashSet<EntityPlayer> receivers = null;
        for (int i = 0; i < baubles.getSlots(); ++i) {
            ItemStack stack = baubles.getStackInSlot(i);
            IBauble bauble = (IBauble)stack.getCapability(BaublesCapabilities.CAPABILITY_ITEM_BAUBLE, null);
            if (!baubles.isChanged(i) && (bauble == null || !bauble.willAutoSync(stack, (EntityLivingBase)player) || ItemStack.func_77989_b((ItemStack)stack, (ItemStack)items[i]))) continue;
            if (receivers == null) {
                receivers = new HashSet<EntityPlayer>(((WorldServer)player.field_70170_p).func_73039_n().getTrackingPlayers((Entity)player));
                receivers.add(player);
            }
            this.syncSlot(player, i, stack, receivers);
            baubles.setChanged(i, false);
            items[i] = stack == null ? ItemStack.field_190927_a : stack.func_77946_l();
        }
    }

    private void syncSlots(EntityPlayer player, Collection<? extends EntityPlayer> receivers) {
        IBaublesItemHandler baubles = BaublesApi.getBaublesHandler(player);
        for (int i = 0; i < baubles.getSlots(); ++i) {
            this.syncSlot(player, i, baubles.getStackInSlot(i), receivers);
        }
    }

    private void syncSlot(EntityPlayer player, int slot, ItemStack stack, Collection<? extends EntityPlayer> receivers) {
        PacketSync pkt = new PacketSync(player, slot, stack);
        for (EntityPlayer entityPlayer : receivers) {
            PacketHandler.INSTANCE.sendTo((IMessage)pkt, (EntityPlayerMP)entityPlayer);
        }
    }

    @SubscribeEvent
    public void playerDeath(PlayerDropsEvent event) {
        if (event.getEntity() instanceof EntityPlayer && !event.getEntity().field_70170_p.field_72995_K && !event.getEntity().field_70170_p.func_82736_K().func_82766_b("keepInventory")) {
            this.dropItemsAt(event.getEntityPlayer(), event.getDrops(), (Entity)event.getEntityPlayer());
        }
    }

    public void dropItemsAt(EntityPlayer player, List<EntityItem> drops, Entity e) {
        IBaublesItemHandler baubles = BaublesApi.getBaublesHandler(player);
        for (int i = 0; i < baubles.getSlots(); ++i) {
            if (baubles.getStackInSlot(i) == null || baubles.getStackInSlot(i).func_190926_b()) continue;
            EntityItem ei = new EntityItem(e.field_70170_p, e.field_70165_t, e.field_70163_u + (double)e.func_70047_e(), e.field_70161_v, baubles.getStackInSlot(i).func_77946_l());
            ei.func_174867_a(40);
            float f1 = e.field_70170_p.field_73012_v.nextFloat() * 0.5f;
            float f2 = e.field_70170_p.field_73012_v.nextFloat() * (float)Math.PI * 2.0f;
            ei.field_70159_w = -MathHelper.func_76126_a((float)f2) * f1;
            ei.field_70179_y = MathHelper.func_76134_b((float)f2) * f1;
            ei.field_70181_x = 0.2f;
            drops.add(ei);
            baubles.setStackInSlot(i, ItemStack.field_190927_a);
        }
    }
}

