/*
 * Decompiled with CFR 0.152.
 */
package net.moddedminecraft.mmcrestrict.Commands;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import net.moddedminecraft.mmcrestrict.Config.Messages;
import net.moddedminecraft.mmcrestrict.Data.ItemData;
import net.moddedminecraft.mmcrestrict.Main;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.spec.CommandExecutor;
import org.spongepowered.api.service.pagination.PaginationService;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.action.ClickAction;
import org.spongepowered.api.text.action.HoverAction;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.api.text.channel.MessageReceiver;

public class BanList
implements CommandExecutor {
    private final Main plugin;

    public BanList(Main plugin) {
        this.plugin = plugin;
    }

    public CommandResult execute(CommandSource src, CommandContext args) throws CommandException {
        ArrayList<ItemData> items = new ArrayList<ItemData>(this.plugin.getItemData());
        PaginationService paginationService = (PaginationService)Sponge.getServiceManager().provide(PaginationService.class).get();
        ArrayList<Text> contents = new ArrayList<Text>();
        for (ItemData item : items) {
            HashMap<String, String> arguments = new HashMap<String, String>();
            arguments.put("banreason", item.getBanreason());
            arguments.put("itemid", item.getItemid());
            arguments.put("usebanned", item.getUsagebanned().toString());
            arguments.put("breakbanned", item.getBreakingbanned().toString());
            arguments.put("placebanned", item.getPlacingbanned().toString());
            arguments.put("ownbanned", item.getOwnershipbanned().toString());
            arguments.put("craftbanned", item.getCraftbanned().toString());
            arguments.put("worldbanned", item.getWorldbanned().toString());
            arguments.put("itemname", item.getItemname());
            Text.Builder send = Text.builder();
            String banreason = "";
            if (!item.getBanreason().isEmpty()) {
                banreason = Messages.bannedItemReason;
            }
            send.append(new Text[]{Messages.parseMessage(Messages.bannedItem + banreason, arguments)});
            String banInfo = Messages.bannedItemHover;
            if (src.hasPermission("mmcrestrict.extra.list")) {
                banInfo = banInfo + "\n" + Messages.bannedItemExtraInfo;
            }
            if (src.hasPermission("mmcrestrict.commands.edit")) {
                banInfo = banInfo + "\n" + Messages.bannedItemEdit;
                send.onClick((ClickAction)TextActions.runCommand((String)("/restrict edit " + item.getItemid())));
            }
            send.onHover((HoverAction)TextActions.showText((Text)Messages.parseMessage(banInfo, arguments)));
            contents.add(send.build());
        }
        if (contents.isEmpty()) {
            contents.add(this.plugin.fromLegacy(Messages.bannedItemNonSet));
        }
        Collections.sort(contents);
        paginationService.builder().title(this.plugin.fromLegacy(Messages.bannedListTitle)).contents(contents).padding(this.plugin.fromLegacy(Messages.bannedListPadding)).sendTo((MessageReceiver)src);
        return CommandResult.success();
    }
}

