/*
 * Decompiled with CFR 0.152.
 */
package gcewing.sg.generator;

import gcewing.sg.generator.FeatureGeneration;
import gcewing.sg.generator.FeatureStargate;
import java.util.Random;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.template.TemplateManager;

public class FeatureJungleTemple
extends FeatureStargate {
    @Override
    protected void func_143011_b(NBTTagCompound compound, TemplateManager templateManager) {
    }

    @Override
    protected void func_143012_a(NBTTagCompound compound) {
    }

    public FeatureJungleTemple() {
    }

    public FeatureJungleTemple(StructureComponent base) {
        this.base = base;
        Random rand = new Random();
        this.generateStructure = rand.nextInt(100) <= FeatureGeneration.jungleAddonChance;
        this.generateChevronUpgrade = rand.nextInt(100) <= FeatureGeneration.jungleChevronUpgradeChance;
        this.generateZpmChest = rand.nextInt(100) <= FeatureGeneration.jungleZpmChestChance;
        this.generateTokra = FeatureGeneration.jungleSpawnTokra;
        boolean bl = this.taintedZpm = rand.nextInt(100) <= FeatureGeneration.genericTaintedZpm;
        if (FeatureGeneration.debugStructures) {
            System.out.println("SGCraft: Creating FeatureJungleTemple with GenerateStructure: " + this.generateStructure);
        }
        StructureBoundingBox baseBox = base.func_74874_b();
        this.centerPos = new BlockPos(baseBox.field_78897_a + (baseBox.field_78893_d - baseBox.field_78897_a + 1) / 2, baseBox.field_78895_b + (baseBox.field_78894_e - baseBox.field_78895_b + 1) / 2, baseBox.field_78896_c + (baseBox.field_78892_f - baseBox.field_78896_c + 1) / 2);
        int cx = this.centerPos.func_177958_n();
        int cz = this.centerPos.func_177952_p();
        int bottom = baseBox.field_78894_e + 10;
        this.field_74887_e = new StructureBoundingBox(cx - 4, bottom, cz - 4, cx + 4, bottom + 6, cz + 4);
        this.spawnDirection = base.func_186165_e();
        this.func_186164_a(EnumFacing.SOUTH);
        if (this.spawnDirection == EnumFacing.SOUTH) {
            this.gateX = 2;
            this.gateY = 4;
            this.gateZ = 4;
            this.gateFaces = EnumFacing.WEST;
            this.dhdX = 5;
            this.dhdY = 4;
            this.dhdZ = 2;
            this.dhdFaces = EnumFacing.WEST;
            this.chestX = 5;
            this.chestY = 4;
            this.chestZ = 6;
            this.chestFaces = EnumFacing.EAST;
        } else if (this.spawnDirection == EnumFacing.NORTH) {
            this.gateX = 2;
            this.gateY = 4;
            this.gateZ = 4;
            this.gateFaces = EnumFacing.WEST;
            this.dhdX = 5;
            this.dhdY = 4;
            this.dhdZ = 2;
            this.dhdFaces = EnumFacing.WEST;
            this.chestX = 5;
            this.chestY = 4;
            this.chestZ = 6;
            this.chestFaces = EnumFacing.EAST;
        } else if (this.spawnDirection == EnumFacing.EAST) {
            this.gateX = 4;
            this.gateY = 4;
            this.gateZ = 2;
            this.gateFaces = EnumFacing.NORTH;
            this.dhdX = 2;
            this.dhdY = 4;
            this.dhdZ = 5;
            this.dhdFaces = EnumFacing.NORTH;
            this.chestX = 6;
            this.chestY = 4;
            this.chestZ = 5;
            this.chestFaces = EnumFacing.SOUTH;
        } else if (this.spawnDirection == EnumFacing.WEST) {
            this.gateX = 4;
            this.gateY = 4;
            this.gateZ = 2;
            this.gateFaces = EnumFacing.NORTH;
            this.dhdX = 6;
            this.dhdY = 4;
            this.dhdZ = 5;
            this.dhdFaces = EnumFacing.NORTH;
            this.chestX = 2;
            this.chestY = 4;
            this.chestZ = 5;
            this.chestFaces = EnumFacing.SOUTH;
        }
        this.gatePos = new BlockPos(this.field_74887_e.field_78897_a + this.gateX, this.field_74887_e.field_78895_b + this.gateY, this.field_74887_e.field_78896_c + this.gateZ);
        ItemStack cobbleBlock = new ItemStack(Blocks.field_150347_e, 1, 0);
        ItemStack mossyBlock = new ItemStack(Blocks.field_150341_Y, 1, 0);
        int tempRand = 0;
        for (int x = 0; x < 5; ++x) {
            tempRand = rand.nextInt(2);
            this.gateCamo[x] = tempRand == 0 ? cobbleBlock : mossyBlock;
        }
        this.dhdPos = new BlockPos(this.field_74887_e.field_78897_a + this.dhdX, this.field_74887_e.field_78895_b + this.dhdY, this.field_74887_e.field_78896_c + this.dhdZ);
        this.chestPos = new BlockPos(this.field_74887_e.field_78897_a + this.chestX, this.field_74887_e.field_78895_b + this.chestY, this.field_74887_e.field_78896_c + this.chestZ);
        if (this.generateStructure && FeatureGeneration.debugStructures) {
            System.out.println("SGCraft: Jungle Temple got a gate at " + this.centerPos + ", facing " + this.spawnDirection);
        }
    }

    @Override
    public boolean func_74875_a(World world, Random rand, StructureBoundingBox clip) {
        return this.generateStructure && this.addAugmentationParts(world, rand, clip);
    }

    @Override
    protected boolean addAugmentationParts(World world, Random rand, StructureBoundingBox clip) {
        if (this.pass == 3 && FeatureGeneration.debugStructures) {
            System.out.printf("SGCraft: FeatureJungleTemple.addComponentParts in %s clipped to %s\n", this.func_74874_b(), clip);
        }
        if (this.base == null) {
            System.out.printf("SGCraft: FeatureJungleTemple.addComponentParts: no base\n", new Object[0]);
            return false;
        }
        if (this.firstY == -1) {
            int tempY = FeatureStargate.getJungleTempleTop(world, this.centerPos) - 5;
            if (tempY < 0) {
                return true;
            }
            this.field_74887_e.field_78895_b = this.firstY = tempY;
            this.gatePos = new BlockPos(this.field_74887_e.field_78897_a + this.gateX, this.field_74887_e.field_78895_b + this.gateY, this.field_74887_e.field_78896_c + this.gateZ);
            this.dhdPos = new BlockPos(this.field_74887_e.field_78897_a + this.dhdX, this.field_74887_e.field_78895_b + this.dhdY, this.field_74887_e.field_78896_c + this.dhdZ);
            this.chestPos = new BlockPos(this.field_74887_e.field_78897_a + this.chestX, this.field_74887_e.field_78895_b + this.chestY, this.field_74887_e.field_78896_c + this.chestZ);
        } else {
            this.field_74887_e.field_78895_b = this.firstY;
        }
        IBlockState air = Blocks.field_150350_a.func_176223_P();
        IBlockState cobble = Blocks.field_150347_e.func_176223_P();
        IBlockState mossy = Blocks.field_150341_Y.func_176223_P();
        IBlockState cobbleStairsS = Blocks.field_150446_ar.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.SOUTH);
        IBlockState cobbleStairsE = Blocks.field_150446_ar.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.EAST);
        this.func_74878_a(world, clip, 1, 4, 1, 7, 7, 7);
        IBlockState id = null;
        for (int x = 3; x < 5; ++x) {
            for (int z = 3; z < 6; ++z) {
                id = cobble;
                if (rand.nextInt(2) > 0) {
                    id = mossy;
                }
                if (this.spawnDirection == EnumFacing.SOUTH || this.spawnDirection == EnumFacing.NORTH) {
                    this.func_175811_a(world, id, x, 3, z, clip);
                    continue;
                }
                this.func_175811_a(world, id, z, 3, x, clip);
            }
        }
        if (this.spawnDirection == EnumFacing.NORTH || this.spawnDirection == EnumFacing.SOUTH) {
            this.func_175811_a(world, cobbleStairsS, 7, 2, 4, clip);
            this.func_175811_a(world, air, 7, 2, 5, clip);
            this.func_175811_a(world, air, 7, 2, 6, clip);
            this.func_175811_a(world, air, 7, 2, 7, clip);
            this.func_175811_a(world, cobbleStairsS, 7, 1, 5, clip);
            this.func_175811_a(world, cobbleStairsS, 7, 0, 6, clip);
        } else {
            this.func_175811_a(world, cobbleStairsE, 4, 2, 7, clip);
            this.func_175811_a(world, air, 3, 2, 7, clip);
            this.func_175811_a(world, air, 2, 2, 7, clip);
            this.func_175811_a(world, air, 1, 2, 7, clip);
            this.func_175811_a(world, cobbleStairsE, 3, 1, 7, clip);
            this.func_175811_a(world, cobbleStairsE, 2, 0, 7, clip);
        }
        this.GenerateStargate(world, clip, true);
        this.GenerateStargateStairs(world, clip, Blocks.field_150446_ar);
        this.GenerateDHD(world, clip);
        this.GenerateChest(world, clip);
        this.GenerateTokRa(world, clip);
        ++this.pass;
        return true;
    }
}

