/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.eaglefactions.common.entities;

import io.github.aquerr.eaglefactions.api.entities.Claim;
import io.github.aquerr.eaglefactions.api.entities.Faction;
import io.github.aquerr.eaglefactions.api.entities.FactionChest;
import io.github.aquerr.eaglefactions.api.entities.FactionHome;
import io.github.aquerr.eaglefactions.api.entities.FactionMemberType;
import io.github.aquerr.eaglefactions.api.entities.FactionPermType;
import io.github.aquerr.eaglefactions.api.logic.FactionLogic;
import io.github.aquerr.eaglefactions.api.managers.PermsManager;
import io.github.aquerr.eaglefactions.common.EagleFactionsPlugin;
import io.github.aquerr.eaglefactions.common.entities.FactionChestImpl;
import java.time.Instant;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.spongepowered.api.text.Text;

public class FactionImpl
implements Faction {
    private final String name;
    private final Text tag;
    private final String description;
    private final String messageOfTheDay;
    private final Set<UUID> recruits;
    private final Set<UUID> members;
    private final Set<String> truces;
    private final Set<String> alliances;
    private final Set<String> enemies;
    private final UUID leader;
    private final Set<UUID> officers;
    private final Set<Claim> claims;
    private final FactionHome home;
    private final Instant lastOnline;
    private final boolean isPublic;
    private final Map<FactionMemberType, Map<FactionPermType, Boolean>> perms;
    private FactionChest chest;

    public FactionImpl(BuilderImpl builder) {
        this.name = builder.name;
        this.tag = builder.tag;
        this.description = builder.description;
        this.messageOfTheDay = builder.messageOfTheDay;
        this.leader = builder.leader;
        this.recruits = builder.recruits;
        this.members = builder.members;
        this.claims = builder.claims;
        this.officers = builder.officers;
        this.truces = builder.truces;
        this.alliances = builder.alliances;
        this.enemies = builder.enemies;
        this.home = builder.home;
        this.lastOnline = builder.lastOnline;
        this.perms = builder.perms;
        this.chest = builder.chest;
        this.isPublic = builder.isPublic;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Text getTag() {
        return this.tag;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getMessageOfTheDay() {
        return this.messageOfTheDay;
    }

    @Override
    public FactionHome getHome() {
        return this.home;
    }

    @Override
    public Set<String> getTruces() {
        return Collections.unmodifiableSet(this.truces);
    }

    @Override
    public Set<String> getAlliances() {
        return Collections.unmodifiableSet(this.alliances);
    }

    @Override
    public Set<Claim> getClaims() {
        return Collections.unmodifiableSet(this.claims);
    }

    @Override
    public Set<String> getEnemies() {
        return Collections.unmodifiableSet(this.enemies);
    }

    @Override
    public Set<UUID> getMembers() {
        return Collections.unmodifiableSet(this.members);
    }

    @Override
    public Set<UUID> getOfficers() {
        return Collections.unmodifiableSet(this.officers);
    }

    @Override
    public Set<UUID> getRecruits() {
        return Collections.unmodifiableSet(this.recruits);
    }

    @Override
    public Set<UUID> getPlayers() {
        HashSet<UUID> players = new HashSet<UUID>();
        players.add(this.getLeader());
        players.addAll(this.getRecruits());
        players.addAll(this.getMembers());
        players.addAll(this.getOfficers());
        return players;
    }

    @Override
    public Map<FactionMemberType, Map<FactionPermType, Boolean>> getPerms() {
        return Collections.unmodifiableMap(this.perms);
    }

    @Override
    public UUID getLeader() {
        return this.leader;
    }

    @Override
    public Instant getLastOnline() {
        return this.lastOnline;
    }

    @Override
    public FactionMemberType getPlayerMemberType(UUID playerUUID) {
        if (this.leader.equals(playerUUID)) {
            return FactionMemberType.LEADER;
        }
        if (this.officers.contains(playerUUID)) {
            return FactionMemberType.OFFICER;
        }
        if (this.members.contains(playerUUID)) {
            return FactionMemberType.MEMBER;
        }
        if (this.recruits.contains(playerUUID)) {
            return FactionMemberType.RECRUIT;
        }
        FactionLogic factionLogic = EagleFactionsPlugin.getPlugin().getFactionLogic();
        Optional<Faction> optionalFaction = this.alliances.stream().map(factionLogic::getFactionByName).filter(Objects::nonNull).filter(y -> y.containsPlayer(playerUUID)).findAny();
        if (optionalFaction.isPresent()) {
            return FactionMemberType.ALLY;
        }
        optionalFaction = this.truces.stream().map(factionLogic::getFactionByName).filter(Objects::nonNull).filter(y -> y.containsPlayer(playerUUID)).findAny();
        if (optionalFaction.isPresent()) {
            return FactionMemberType.TRUCE;
        }
        return null;
    }

    @Override
    public FactionChest getChest() {
        return this.chest;
    }

    @Override
    public boolean isPublic() {
        return this.isPublic;
    }

    @Override
    public boolean containsPlayer(UUID playerUUID) {
        if (this.leader.equals(playerUUID)) {
            return true;
        }
        if (this.officers.contains(playerUUID)) {
            return true;
        }
        if (this.members.contains(playerUUID)) {
            return true;
        }
        return this.recruits.contains(playerUUID);
    }

    @Override
    public Faction.Builder toBuilder() {
        BuilderImpl factionBuilder = new BuilderImpl();
        factionBuilder.setName(this.name);
        factionBuilder.setTag(this.tag);
        factionBuilder.setDescription(this.description);
        factionBuilder.setMessageOfTheDay(this.messageOfTheDay);
        factionBuilder.setLeader(this.leader);
        factionBuilder.setOfficers(this.officers);
        factionBuilder.setMembers(this.members);
        factionBuilder.setRecruits(this.recruits);
        factionBuilder.setAlliances(this.alliances);
        factionBuilder.setEnemies(this.enemies);
        factionBuilder.setClaims(this.claims);
        factionBuilder.setLastOnline(this.lastOnline);
        factionBuilder.setHome(this.home);
        factionBuilder.setPerms(this.perms);
        factionBuilder.setChest(this.chest);
        factionBuilder.setIsPublic(this.isPublic);
        return factionBuilder;
    }

    public static Faction.Builder builder(String name, Text tag, UUID leader) {
        return new BuilderImpl(name, tag, leader);
    }

    @Override
    public int compareTo(Faction object) {
        return this.name.compareTo(object.getName());
    }

    public static final class BuilderImpl
    implements Faction.Builder {
        private String name;
        private Text tag;
        private String description = "";
        private String messageOfTheDay = "";
        private UUID leader;
        private Set<UUID> recruits = new HashSet<UUID>();
        private Set<UUID> members = new HashSet<UUID>();
        private Set<String> truces = new HashSet<String>();
        private Set<String> alliances = new HashSet<String>();
        private Set<String> enemies = new HashSet<String>();
        private Set<UUID> officers = new HashSet<UUID>();
        private Set<Claim> claims = new HashSet<Claim>();
        private FactionHome home = null;
        private Instant lastOnline;
        private Map<FactionMemberType, Map<FactionPermType, Boolean>> perms;
        private FactionChest chest;
        private boolean isPublic = false;

        private BuilderImpl() {
        }

        public BuilderImpl(String name, Text tag, UUID leader) {
            this();
            this.name = name;
            this.tag = tag;
            this.leader = leader;
            this.chest = new FactionChestImpl(this.name);
        }

        @Override
        public Faction.Builder setName(String name) {
            this.name = name;
            return this;
        }

        @Override
        public Faction.Builder setTag(Text tag) {
            this.tag = tag;
            return this;
        }

        @Override
        public Faction.Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        @Override
        public Faction.Builder setMessageOfTheDay(String messageOfTheDay) {
            this.messageOfTheDay = messageOfTheDay;
            return this;
        }

        @Override
        public Faction.Builder setLeader(UUID leaderUUID) {
            this.leader = leaderUUID;
            return this;
        }

        @Override
        public Faction.Builder setRecruits(Set<UUID> recruits) {
            this.recruits = recruits;
            return this;
        }

        @Override
        public Faction.Builder setMembers(Set<UUID> members) {
            this.members = members;
            return this;
        }

        @Override
        public Faction.Builder setOfficers(Set<UUID> officers) {
            this.officers = officers;
            return this;
        }

        @Override
        public Faction.Builder setTruces(Set<String> truces) {
            this.truces = truces;
            return this;
        }

        @Override
        public Faction.Builder setAlliances(Set<String> alliances) {
            this.alliances = alliances;
            return this;
        }

        @Override
        public Faction.Builder setEnemies(Set<String> enemies) {
            this.enemies = enemies;
            return this;
        }

        @Override
        public Faction.Builder setClaims(Set<Claim> claims) {
            this.claims = claims;
            return this;
        }

        @Override
        public Faction.Builder setHome(FactionHome home) {
            this.home = home;
            return this;
        }

        @Override
        public Faction.Builder setLastOnline(Instant lastOnline) {
            this.lastOnline = lastOnline;
            return this;
        }

        @Override
        public Faction.Builder setPerms(Map<FactionMemberType, Map<FactionPermType, Boolean>> perms) {
            this.perms = perms;
            return this;
        }

        @Override
        public Faction.Builder setChest(FactionChest chest) {
            this.chest = chest;
            return this;
        }

        @Override
        public Faction.Builder setIsPublic(boolean isPublic) {
            this.isPublic = isPublic;
            return this;
        }

        @Override
        public Faction build() {
            if (this.name == null || this.tag == null || this.leader == null) {
                throw new IllegalStateException("Couldn't build Faction object! Faction must have a name, a tag and a leader!");
            }
            if (this.lastOnline == null) {
                this.lastOnline = Instant.now();
            }
            if (this.perms == null) {
                this.perms = PermsManager.getDefaultFactionPerms();
            }
            if (this.chest == null) {
                this.chest = new FactionChestImpl(this.name);
            }
            return new FactionImpl(this);
        }
    }
}

