/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.eaglefactions.common.logic;

import com.flowpowered.math.vector.Vector3i;
import com.google.common.base.Strings;
import io.github.aquerr.eaglefactions.api.config.FactionsConfig;
import io.github.aquerr.eaglefactions.api.entities.Claim;
import io.github.aquerr.eaglefactions.api.entities.Faction;
import io.github.aquerr.eaglefactions.api.entities.FactionChest;
import io.github.aquerr.eaglefactions.api.entities.FactionHome;
import io.github.aquerr.eaglefactions.api.entities.FactionMemberType;
import io.github.aquerr.eaglefactions.api.entities.FactionPermType;
import io.github.aquerr.eaglefactions.api.logic.FactionLogic;
import io.github.aquerr.eaglefactions.api.managers.PlayerManager;
import io.github.aquerr.eaglefactions.api.storage.StorageManager;
import io.github.aquerr.eaglefactions.common.PluginInfo;
import io.github.aquerr.eaglefactions.common.caching.FactionsCache;
import io.github.aquerr.eaglefactions.common.messaging.MessageLoader;
import io.github.aquerr.eaglefactions.common.messaging.Messages;
import io.github.aquerr.eaglefactions.common.messaging.Placeholders;
import io.github.aquerr.eaglefactions.common.scheduling.ClaimDelayTask;
import io.github.aquerr.eaglefactions.common.scheduling.EagleFactionsScheduler;
import io.github.aquerr.eaglefactions.common.util.ParticlesUtil;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.entity.PlayerInventory;
import org.spongepowered.api.item.inventory.query.QueryOperation;
import org.spongepowered.api.item.inventory.query.QueryOperationTypes;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColor;
import org.spongepowered.api.text.format.TextColors;

public class FactionLogicImpl
implements FactionLogic {
    private final StorageManager storageManager;
    private final FactionsConfig factionsConfig;
    private final PlayerManager playerManager;
    private final UUID DUMMY_UUID = new UUID(0L, 0L);

    public FactionLogicImpl(PlayerManager playerManager, StorageManager storageManager, FactionsConfig factionsConfig) {
        this.storageManager = storageManager;
        this.playerManager = playerManager;
        this.factionsConfig = factionsConfig;
    }

    @Override
    public Optional<Faction> getFactionByPlayerUUID(UUID playerUUID) {
        for (Faction faction : this.getFactions().values()) {
            if (faction.getLeader() != null && faction.getLeader().equals(playerUUID)) {
                return Optional.of(faction);
            }
            if (faction.getOfficers().contains(playerUUID)) {
                return Optional.of(faction);
            }
            if (faction.getMembers().contains(playerUUID)) {
                return Optional.of(faction);
            }
            if (!faction.getRecruits().contains(playerUUID)) continue;
            return Optional.of(faction);
        }
        return Optional.empty();
    }

    @Override
    public Optional<Faction> getFactionByChunk(UUID worldUUID, Vector3i chunk) {
        Claim claim = new Claim(worldUUID, chunk);
        for (Faction faction : this.getFactions().values()) {
            if (!faction.getClaims().contains(claim)) continue;
            return Optional.of(faction);
        }
        return Optional.empty();
    }

    @Override
    @Nullable
    public Faction getFactionByName(String factionName) {
        return this.storageManager.getFaction(factionName);
    }

    @Override
    public List<Player> getOnlinePlayers(Faction faction) {
        ArrayList<Player> factionPlayers = new ArrayList<Player>();
        UUID factionLeader = faction.getLeader();
        if (!faction.getLeader().equals(this.DUMMY_UUID) && this.playerManager.isPlayerOnline(factionLeader)) {
            factionPlayers.add(this.playerManager.getPlayer(factionLeader).get());
        }
        for (UUID uuid : faction.getOfficers()) {
            if (!this.playerManager.isPlayerOnline(uuid)) continue;
            factionPlayers.add(this.playerManager.getPlayer(uuid).get());
        }
        for (UUID uuid : faction.getMembers()) {
            if (!this.playerManager.isPlayerOnline(uuid)) continue;
            factionPlayers.add(this.playerManager.getPlayer(uuid).get());
        }
        for (UUID uuid : faction.getRecruits()) {
            if (!this.playerManager.isPlayerOnline(uuid)) continue;
            factionPlayers.add(this.playerManager.getPlayer(uuid).get());
        }
        return factionPlayers;
    }

    @Override
    public Set<String> getFactionsNames() {
        return this.getFactions().keySet();
    }

    @Override
    public Map<String, Faction> getFactions() {
        return FactionsCache.getFactionsMap();
    }

    @Override
    public void addFaction(Faction faction) {
        this.storageManager.addOrUpdateFaction(faction);
    }

    @Override
    public boolean disbandFaction(String factionName) {
        Objects.requireNonNull(factionName);
        boolean isDisbanded = this.storageManager.deleteFaction(factionName);
        ArrayList<Faction> tempFactions = new ArrayList<Faction>(this.getFactions().values());
        for (Faction faction : tempFactions) {
            if (faction.getTruces().contains(factionName)) {
                this.removeTruce(faction.getName(), factionName);
                continue;
            }
            if (faction.getAlliances().contains(factionName)) {
                this.removeAlly(faction.getName(), factionName);
                continue;
            }
            if (!faction.getEnemies().contains(factionName)) continue;
            this.removeEnemy(faction.getName(), factionName);
        }
        return isDisbanded;
    }

    @Override
    public void joinFaction(UUID playerUUID, String factionName) {
        if (playerUUID == null || factionName.equals("")) {
            throw new IllegalArgumentException("playerUUID can't be null and/or factionName can't be empty.");
        }
        Faction faction = this.getFactionByName(factionName);
        HashSet<UUID> recruits = new HashSet<UUID>(faction.getRecruits());
        recruits.add(playerUUID);
        Faction updatedFaction = faction.toBuilder().setRecruits(recruits).build();
        this.storageManager.addOrUpdateFaction(updatedFaction);
    }

    @Override
    public void leaveFaction(UUID playerUUID, String factionName) {
        Faction faction = this.getFactionByName(factionName);
        HashSet<UUID> recruits = new HashSet<UUID>(faction.getRecruits());
        HashSet<UUID> members = new HashSet<UUID>(faction.getMembers());
        HashSet<UUID> officers = new HashSet<UUID>(faction.getOfficers());
        if (faction.getRecruits().contains(playerUUID)) {
            recruits.remove(playerUUID);
        } else if (faction.getMembers().contains(playerUUID)) {
            members.remove(playerUUID);
        } else {
            officers.remove(playerUUID);
        }
        Faction updatedFaction = faction.toBuilder().setRecruits(recruits).setMembers(members).setOfficers(officers).build();
        this.storageManager.addOrUpdateFaction(updatedFaction);
    }

    @Override
    public void addTruce(String playerFactionName, String invitedFactionName) {
        if (Strings.isNullOrEmpty((String)playerFactionName) || Strings.isNullOrEmpty((String)invitedFactionName)) {
            throw new IllegalArgumentException("playerFactionName and invitedFactionName must contain a value.");
        }
        Faction playerFaction = this.getFactionByName(playerFactionName);
        Faction invitedFaction = this.getFactionByName(invitedFactionName);
        HashSet<String> playerFactionAlliances = new HashSet<String>(playerFaction.getTruces());
        HashSet<String> invitedFactionAlliances = new HashSet<String>(invitedFaction.getTruces());
        playerFactionAlliances.add(invitedFactionName);
        invitedFactionAlliances.add(playerFactionName);
        Faction updatedPlayerFaction = playerFaction.toBuilder().setTruces(playerFactionAlliances).build();
        Faction updatedInvitedFaction = invitedFaction.toBuilder().setTruces(invitedFactionAlliances).build();
        this.storageManager.addOrUpdateFaction(updatedPlayerFaction);
        this.storageManager.addOrUpdateFaction(updatedInvitedFaction);
    }

    @Override
    public void removeTruce(String playerFactionName, String removedFactionName) {
        if (Strings.isNullOrEmpty((String)playerFactionName) || Strings.isNullOrEmpty((String)removedFactionName)) {
            throw new IllegalArgumentException("playerFactionName and invitedFactionName must contain a value.");
        }
        Faction playerFaction = this.getFactionByName(playerFactionName);
        Faction removedFaction = this.getFactionByName(removedFactionName);
        HashSet<String> playerFactionAlliances = new HashSet<String>(playerFaction.getTruces());
        HashSet<String> removedFactionAlliances = new HashSet<String>(removedFaction.getTruces());
        playerFactionAlliances.remove(removedFactionName);
        removedFactionAlliances.remove(playerFactionName);
        Faction updatedPlayerFaction = playerFaction.toBuilder().setTruces(playerFactionAlliances).build();
        Faction updatedRemovedFaction = removedFaction.toBuilder().setTruces(removedFactionAlliances).build();
        this.storageManager.addOrUpdateFaction(updatedPlayerFaction);
        this.storageManager.addOrUpdateFaction(updatedRemovedFaction);
    }

    @Override
    public void addAlly(String playerFactionName, String invitedFactionName) {
        if (Strings.isNullOrEmpty((String)playerFactionName) || Strings.isNullOrEmpty((String)invitedFactionName)) {
            throw new IllegalArgumentException("playerFactionName and invitedFactionName must contain a value.");
        }
        Faction playerFaction = this.getFactionByName(playerFactionName);
        Faction invitedFaction = this.getFactionByName(invitedFactionName);
        HashSet<String> playerFactionAlliances = new HashSet<String>(playerFaction.getAlliances());
        HashSet<String> invitedFactionAlliances = new HashSet<String>(invitedFaction.getAlliances());
        playerFactionAlliances.add(invitedFactionName);
        invitedFactionAlliances.add(playerFactionName);
        Faction updatedPlayerFaction = playerFaction.toBuilder().setAlliances(playerFactionAlliances).build();
        Faction updatedInvitedFaction = invitedFaction.toBuilder().setAlliances(invitedFactionAlliances).build();
        this.storageManager.addOrUpdateFaction(updatedPlayerFaction);
        this.storageManager.addOrUpdateFaction(updatedInvitedFaction);
    }

    @Override
    public void removeAlly(String playerFactionName, String removedFactionName) {
        if (Strings.isNullOrEmpty((String)playerFactionName) || Strings.isNullOrEmpty((String)removedFactionName)) {
            throw new IllegalArgumentException("playerFactionName and invitedFactionName must contain a value.");
        }
        Faction playerFaction = this.getFactionByName(playerFactionName);
        Faction removedFaction = this.getFactionByName(removedFactionName);
        HashSet<String> playerFactionAlliances = new HashSet<String>(playerFaction.getAlliances());
        HashSet<String> removedFactionAlliances = new HashSet<String>(removedFaction.getAlliances());
        playerFactionAlliances.remove(removedFactionName);
        removedFactionAlliances.remove(playerFactionName);
        Faction updatedPlayerFaction = playerFaction.toBuilder().setAlliances(playerFactionAlliances).build();
        Faction updatedRemovedFaction = removedFaction.toBuilder().setAlliances(removedFactionAlliances).build();
        this.storageManager.addOrUpdateFaction(updatedPlayerFaction);
        this.storageManager.addOrUpdateFaction(updatedRemovedFaction);
    }

    @Override
    public void addEnemy(String playerFactionName, String enemyFactionName) {
        if (Strings.isNullOrEmpty((String)playerFactionName) || Strings.isNullOrEmpty((String)enemyFactionName)) {
            throw new IllegalArgumentException("playerFactionName and invitedFactionName must contain a value.");
        }
        Faction playerFaction = this.getFactionByName(playerFactionName);
        Faction enemyFaction = this.getFactionByName(enemyFactionName);
        HashSet<String> playerFactionEnemies = new HashSet<String>(playerFaction.getEnemies());
        HashSet<String> enemyFactionEnemies = new HashSet<String>(enemyFaction.getEnemies());
        playerFactionEnemies.add(enemyFactionName);
        enemyFactionEnemies.add(playerFactionName);
        Faction updatedPlayerFaction = playerFaction.toBuilder().setEnemies(playerFactionEnemies).build();
        Faction updatedEnemyFaction = enemyFaction.toBuilder().setEnemies(enemyFactionEnemies).build();
        this.storageManager.addOrUpdateFaction(updatedPlayerFaction);
        this.storageManager.addOrUpdateFaction(updatedEnemyFaction);
    }

    @Override
    public void removeEnemy(String playerFactionName, String enemyFactionName) {
        if (Strings.isNullOrEmpty((String)playerFactionName) || Strings.isNullOrEmpty((String)enemyFactionName)) {
            throw new IllegalArgumentException("playerFactionName and invitedFactionName must contain a value.");
        }
        Faction playerFaction = this.getFactionByName(playerFactionName);
        Faction enemyFaction = this.getFactionByName(enemyFactionName);
        HashSet<String> playerFactionEnemies = new HashSet<String>(playerFaction.getEnemies());
        HashSet<String> enemyFactionEnemies = new HashSet<String>(enemyFaction.getEnemies());
        playerFactionEnemies.remove(enemyFactionName);
        enemyFactionEnemies.remove(playerFactionName);
        Faction updatedPlayerFaction = playerFaction.toBuilder().setEnemies(playerFactionEnemies).build();
        Faction updatedEnemyFaction = enemyFaction.toBuilder().setEnemies(enemyFactionEnemies).build();
        this.storageManager.addOrUpdateFaction(updatedPlayerFaction);
        this.storageManager.addOrUpdateFaction(updatedEnemyFaction);
    }

    @Override
    public void setLeader(UUID newLeaderUUID, String playerFactionName) {
        Faction faction = this.getFactionByName(playerFactionName);
        if (faction == null) {
            return;
        }
        HashSet<UUID> officers = new HashSet<UUID>(faction.getOfficers());
        HashSet<UUID> members = new HashSet<UUID>(faction.getMembers());
        HashSet<UUID> recruits = new HashSet<UUID>(faction.getRecruits());
        if (!faction.getLeader().equals(this.DUMMY_UUID)) {
            officers.add(faction.getLeader());
        }
        if (faction.getOfficers().contains(newLeaderUUID)) {
            officers.remove(newLeaderUUID);
        } else if (faction.getMembers().contains(newLeaderUUID)) {
            members.remove(newLeaderUUID);
        } else if (faction.getRecruits().contains(newLeaderUUID)) {
            recruits.remove(newLeaderUUID);
        }
        Faction updatedFaction = faction.toBuilder().setLeader(newLeaderUUID).setOfficers(officers).setMembers(members).setRecruits(recruits).build();
        this.storageManager.addOrUpdateFaction(updatedFaction);
    }

    @Override
    public Set<Claim> getAllClaims() {
        return FactionsCache.getAllClaims();
    }

    @Override
    public void addClaims(Faction faction, List<Claim> claims) {
        HashSet<Claim> factionClaims = new HashSet<Claim>(faction.getClaims());
        for (Claim claim : claims) {
            factionClaims.add(claim);
            ParticlesUtil.spawnClaimParticles(claim);
        }
        Faction updatedFaction = faction.toBuilder().setClaims(factionClaims).build();
        this.storageManager.addOrUpdateFaction(updatedFaction);
    }

    @Override
    public void addClaim(Faction faction, Claim claim) {
        HashSet<Claim> claims = new HashSet<Claim>(faction.getClaims());
        claims.add(claim);
        Faction updatedFaction = faction.toBuilder().setClaims(claims).build();
        this.storageManager.addOrUpdateFaction(updatedFaction);
        ParticlesUtil.spawnClaimParticles(claim);
    }

    @Override
    public void removeClaim(Faction faction, Claim claim) {
        this.removeClaimInternal(faction, claim);
        ParticlesUtil.spawnUnclaimParticles(claim);
    }

    @Override
    public void destroyClaim(Faction faction, Claim claim) {
        this.removeClaimInternal(faction, claim);
        ParticlesUtil.spawnDestroyClaimParticles(claim);
    }

    @Override
    public boolean isClaimed(UUID worldUUID, Vector3i chunk) {
        for (Claim claim : this.getAllClaims()) {
            if (!claim.getWorldUUID().equals(worldUUID) || !claim.getChunkPosition().equals((Object)chunk)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isClaimConnected(Faction faction, Claim claimToCheck) {
        if (faction.getClaims().size() == 0) {
            return true;
        }
        for (Claim claim : faction.getClaims()) {
            if (!claimToCheck.getWorldUUID().equals(claim.getWorldUUID())) continue;
            Vector3i chunkToCheck = claimToCheck.getChunkPosition();
            Vector3i claimChunk = claim.getChunkPosition();
            if (claimChunk.getX() == chunkToCheck.getX() && (claimChunk.getZ() + 1 == chunkToCheck.getZ() || claimChunk.getZ() - 1 == chunkToCheck.getZ())) {
                return true;
            }
            if (claimChunk.getZ() != chunkToCheck.getZ() || claimChunk.getX() + 1 != chunkToCheck.getX() && claimChunk.getX() - 1 != chunkToCheck.getX()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setHome(Faction faction, @Nullable FactionHome home) {
        faction = home != null && home.getBlockPosition() != null && home.getWorldUUID() != null ? faction.toBuilder().setHome(home).build() : faction.toBuilder().setHome(null).build();
        this.storageManager.addOrUpdateFaction(faction);
    }

    @Override
    public List<String> getFactionsTags() {
        ArrayList<Faction> factionsList = new ArrayList<Faction>(this.getFactions().values());
        ArrayList<String> factionsTags = new ArrayList<String>();
        for (Faction faction : factionsList) {
            factionsTags.add(faction.getTag().toPlain());
        }
        return factionsTags;
    }

    @Override
    public boolean hasOnlinePlayers(Faction faction) {
        if (faction.getLeader() != null && !faction.getLeader().toString().equals("") && this.playerManager.isPlayerOnline(faction.getLeader())) {
            return true;
        }
        for (UUID playerUUID : faction.getOfficers()) {
            if (!this.playerManager.isPlayerOnline(playerUUID)) continue;
            return true;
        }
        for (UUID playerUUID : faction.getMembers()) {
            if (!this.playerManager.isPlayerOnline(playerUUID)) continue;
            return true;
        }
        for (UUID playerUUID : faction.getRecruits()) {
            if (!this.playerManager.isPlayerOnline(playerUUID)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void removeAllClaims(Faction faction) {
        for (Claim claim : faction.getClaims()) {
            FactionsCache.removeClaimCache(claim);
        }
        Faction updatedFaction = faction.toBuilder().setClaims(new HashSet<Claim>()).build();
        this.storageManager.addOrUpdateFaction(updatedFaction);
    }

    @Override
    public void kickPlayer(UUID playerUUID, String factionName) {
        Faction faction = this.getFactionByName(factionName);
        HashSet<UUID> officers = new HashSet<UUID>(faction.getOfficers());
        HashSet<UUID> members = new HashSet<UUID>(faction.getMembers());
        HashSet<UUID> recruits = new HashSet<UUID>(faction.getRecruits());
        if (faction.getRecruits().contains(playerUUID)) {
            recruits.remove(playerUUID);
        } else if (faction.getMembers().contains(playerUUID)) {
            members.remove(playerUUID);
        } else {
            officers.remove(playerUUID);
        }
        Faction updatedFaction = faction.toBuilder().setOfficers(officers).setMembers(members).setRecruits(recruits).build();
        this.storageManager.addOrUpdateFaction(updatedFaction);
    }

    @Override
    public void startClaiming(Player player, Faction faction, UUID worldUUID, Vector3i chunkPosition) {
        if (this.factionsConfig.shouldDelayClaim()) {
            player.sendMessage(Text.of((Object[])new Object[]{PluginInfo.PLUGIN_PREFIX, TextColors.GREEN, MessageLoader.parseMessage(Messages.STAY_IN_THE_CHUNK_FOR_NUMBER_SECONDS_TO_CLAIM_IT, Collections.singletonMap(Placeholders.NUMBER, Text.of((Object[])new Object[]{TextColors.GOLD, this.factionsConfig.getClaimDelay()})))}));
            EagleFactionsScheduler.getInstance().scheduleWithDelayedInterval(new ClaimDelayTask(player, chunkPosition), 1L, TimeUnit.SECONDS, 1L, TimeUnit.SECONDS);
        } else if (this.factionsConfig.shouldClaimByItems()) {
            boolean didSucceed = this.addClaimByItems(player, faction, worldUUID, chunkPosition);
            if (didSucceed) {
                player.sendMessage(Text.of((Object[])new Object[]{PluginInfo.PLUGIN_PREFIX, Messages.LAND + " ", TextColors.GOLD, chunkPosition.toString(), TextColors.WHITE, " " + Messages.HAS_BEEN_SUCCESSFULLY + " ", TextColors.GOLD, Messages.CLAIMED, TextColors.WHITE, "!"}));
            } else {
                player.sendMessage(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, Messages.YOU_DONT_HAVE_ENOUGH_RESOURCES_TO_CLAIM_A_TERRITORY}));
            }
        } else {
            player.sendMessage(Text.of((Object[])new Object[]{PluginInfo.PLUGIN_PREFIX, Messages.LAND + " ", TextColors.GOLD, chunkPosition.toString(), TextColors.WHITE, " " + Messages.HAS_BEEN_SUCCESSFULLY + " ", TextColors.GOLD, Messages.CLAIMED, TextColors.WHITE, "!"}));
            this.addClaim(faction, new Claim(worldUUID, chunkPosition));
        }
    }

    @Override
    public boolean addClaimByItems(Player player, Faction faction, UUID worldUUID, Vector3i chunkPosition) {
        BlockState blockState;
        int variant;
        ItemStack itemStack;
        Optional itemType;
        String itemId;
        String[] idAndVariant;
        Map<String, Integer> requiredItems = this.factionsConfig.getRequiredItemsToClaim();
        PlayerInventory inventory = (PlayerInventory)player.getInventory().query(new QueryOperation[]{QueryOperationTypes.INVENTORY_TYPE.of(PlayerInventory.class)});
        int allRequiredItems = requiredItems.size();
        int foundItems = 0;
        for (String requiredItem : requiredItems.keySet()) {
            idAndVariant = requiredItem.split(":");
            itemId = idAndVariant[0] + ":" + idAndVariant[1];
            itemType = Sponge.getRegistry().getType(ItemType.class, itemId);
            if (!itemType.isPresent()) continue;
            itemStack = ItemStack.builder().itemType((ItemType)itemType.get()).build();
            itemStack.setQuantity(requiredItems.get(requiredItem).intValue());
            if (idAndVariant.length == 3 && ((ItemType)itemType.get()).getBlock().isPresent()) {
                variant = Integer.parseInt(idAndVariant[2]);
                blockState = (BlockState)((BlockType)((ItemType)itemType.get()).getBlock().get()).getAllBlockStates().toArray()[variant];
                itemStack = ItemStack.builder().fromBlockState(blockState).build();
            }
            if (inventory.contains(itemStack)) {
                ++foundItems;
                continue;
            }
            return false;
        }
        if (allRequiredItems == foundItems) {
            for (String requiredItem : requiredItems.keySet()) {
                idAndVariant = requiredItem.split(":");
                itemId = idAndVariant[0] + ":" + idAndVariant[1];
                itemType = Sponge.getRegistry().getType(ItemType.class, itemId);
                if (!itemType.isPresent()) continue;
                itemStack = ItemStack.builder().itemType((ItemType)itemType.get()).build();
                itemStack.setQuantity(requiredItems.get(requiredItem).intValue());
                if (idAndVariant.length == 3 && ((ItemType)itemType.get()).getBlock().isPresent()) {
                    variant = Integer.parseInt(idAndVariant[2]);
                    blockState = (BlockState)((BlockType)((ItemType)itemType.get()).getBlock().get()).getAllBlockStates().toArray()[variant];
                    itemStack = ItemStack.builder().fromBlockState(blockState).build();
                }
                inventory.query(new QueryOperation[]{QueryOperationTypes.ITEM_TYPE.of(itemType.get())}).poll(itemStack.getQuantity());
            }
            this.addClaim(faction, new Claim(worldUUID, chunkPosition));
            return true;
        }
        return false;
    }

    @Override
    public void toggleFlag(Faction faction, FactionMemberType factionMemberType, FactionPermType factionPermType, Boolean flagValue) {
        HashMap<FactionMemberType, Map<FactionPermType, Boolean>> perms = new HashMap<FactionMemberType, Map<FactionPermType, Boolean>>(faction.getPerms());
        ((Map)perms.get((Object)factionMemberType)).replace(factionPermType, flagValue);
        Faction updatedFaction = faction.toBuilder().setPerms(perms).build();
        this.storageManager.addOrUpdateFaction(updatedFaction);
    }

    @Override
    public void changeTagColor(Faction faction, TextColor textColor) {
        Text text = Text.of((Object[])new Object[]{textColor, faction.getTag().toPlainSingle()});
        Faction updatedFaction = faction.toBuilder().setTag(text).build();
        this.storageManager.addOrUpdateFaction(updatedFaction);
    }

    @Override
    public FactionMemberType promotePlayer(Faction faction, UUID playerToPromote) {
        FactionMemberType promotedTo = FactionMemberType.RECRUIT;
        HashSet<UUID> recruits = new HashSet<UUID>(faction.getRecruits());
        HashSet<UUID> members = new HashSet<UUID>(faction.getMembers());
        HashSet<UUID> officers = new HashSet<UUID>(faction.getOfficers());
        if (recruits.contains(playerToPromote)) {
            members.add(playerToPromote);
            recruits.remove(playerToPromote);
            promotedTo = FactionMemberType.MEMBER;
        } else if (members.contains(playerToPromote)) {
            officers.add(playerToPromote);
            members.remove(playerToPromote);
            promotedTo = FactionMemberType.OFFICER;
        }
        Faction updatedFaction = faction.toBuilder().setRecruits(recruits).setOfficers(officers).setMembers(members).build();
        this.storageManager.addOrUpdateFaction(updatedFaction);
        return promotedTo;
    }

    @Override
    public FactionMemberType demotePlayer(Faction faction, UUID playerToDemote) {
        FactionMemberType demotedTo = FactionMemberType.RECRUIT;
        HashSet<UUID> recruits = new HashSet<UUID>(faction.getRecruits());
        HashSet<UUID> members = new HashSet<UUID>(faction.getMembers());
        HashSet<UUID> officers = new HashSet<UUID>(faction.getOfficers());
        if (members.contains(playerToDemote)) {
            recruits.add(playerToDemote);
            members.remove(playerToDemote);
            demotedTo = FactionMemberType.RECRUIT;
        } else if (officers.contains(playerToDemote)) {
            members.add(playerToDemote);
            officers.remove(playerToDemote);
            demotedTo = FactionMemberType.MEMBER;
        }
        Faction updatedFaction = faction.toBuilder().setRecruits(recruits).setOfficers(officers).setMembers(members).build();
        this.storageManager.addOrUpdateFaction(updatedFaction);
        return demotedTo;
    }

    @Override
    public void setLastOnline(Faction faction, Instant instantTime) {
        Faction updatedFaction = faction.toBuilder().setLastOnline(instantTime).build();
        this.storageManager.addOrUpdateFaction(updatedFaction);
    }

    @Override
    public void renameFaction(Faction faction, String newFactionName) {
        this.storageManager.deleteFaction(faction.getName());
        Faction updatedFaction = faction.toBuilder().setName(newFactionName).build();
        this.storageManager.addOrUpdateFaction(updatedFaction);
    }

    @Override
    public void changeTag(Faction faction, String newTag) {
        Faction updatedFaction = faction.toBuilder().setTag(Text.of((Object[])new Object[]{faction.getTag().getColor(), newTag})).build();
        this.storageManager.addOrUpdateFaction(updatedFaction);
    }

    @Override
    public void setChest(Faction faction, FactionChest inventory) {
        Faction updatedFaction = faction.toBuilder().setChest(inventory).build();
        this.storageManager.addOrUpdateFaction(updatedFaction);
    }

    @Override
    public void setDescription(Faction faction, String description) {
        Faction updatedFaction = faction.toBuilder().setDescription(description).build();
        this.storageManager.addOrUpdateFaction(updatedFaction);
    }

    @Override
    public void setMessageOfTheDay(Faction faction, String motd) {
        Faction updatedFaction = faction.toBuilder().setMessageOfTheDay(motd).build();
        this.storageManager.addOrUpdateFaction(updatedFaction);
    }

    @Override
    public void setIsPublic(Faction faction, boolean isPublic) {
        Faction updatedFaction = faction.toBuilder().setIsPublic(isPublic).build();
        this.storageManager.addOrUpdateFaction(updatedFaction);
    }

    private void removeClaimInternal(Faction faction, Claim claim) {
        HashSet<Claim> claims = new HashSet<Claim>(faction.getClaims());
        claims.remove(claim);
        Faction updatedFaction = faction.toBuilder().setClaims(claims).build();
        FactionsCache.removeClaimCache(claim);
        this.storageManager.addOrUpdateFaction(updatedFaction);
    }
}

