/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.config.fieldmap;

import com.direwolf20.buildinggadgets.common.config.PatternList;
import java.util.function.Function;

public class FieldMapper<FieldVal, SyncedVal> {
    public static final String PATTERN_LIST_MAPPER_ID = "Pattern List Mapper";
    public static final FieldMapper<PatternList, String[]> PATTERN_LIST_MAPPER = FieldMapper.of(PatternList::toArray, PatternList::ofResourcePattern, PatternList.class, String[].class);
    private final Function<FieldVal, SyncedVal> fieldToSync;
    private final Function<SyncedVal, FieldVal> syncToField;
    private final Class<FieldVal> fieldType;
    private final Class<SyncedVal> syncedType;

    public static <F> FieldMapper<F, F> id(Class<F> theClass) {
        return FieldMapper.of(Function.identity(), Function.identity(), theClass, theClass);
    }

    public static <FieldVal, SyncedVal> FieldMapper<FieldVal, SyncedVal> of(Function<FieldVal, SyncedVal> fieldToSync, Function<SyncedVal, FieldVal> syncToField, Class<FieldVal> fieldType, Class<SyncedVal> syncedType) {
        return new FieldMapper<FieldVal, SyncedVal>((Function)fieldToSync, (Function)syncToField, (Class)fieldType, (Class)syncedType){};
    }

    private FieldMapper(Function<FieldVal, SyncedVal> fieldToSync, Function<SyncedVal, FieldVal> syncToField, Class<FieldVal> fieldType, Class<SyncedVal> syncedType) {
        this.fieldToSync = fieldToSync;
        this.syncToField = syncToField;
        this.fieldType = fieldType;
        this.syncedType = syncedType;
    }

    public SyncedVal mapToSync(FieldVal val) {
        return this.fieldToSync.apply(val);
    }

    public FieldVal mapToField(SyncedVal val) {
        return this.syncToField.apply(val);
    }

    public Class<FieldVal> getFieldType() {
        return this.fieldType;
    }

    public Class<SyncedVal> getSyncedType() {
        return this.syncedType;
    }
}

