/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.advert.network;

import io.netty.buffer.ByteBuf;
import net.malisis.advert.MalisisAdvert;
import net.malisis.advert.advert.Advert;
import net.malisis.advert.advert.ClientAdvert;
import net.malisis.advert.advert.ServerAdvert;
import net.malisis.core.network.IMalisisMessageHandler;
import net.malisis.core.registry.AutoLoad;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

@AutoLoad(value=true)
public class AdvertDeleteMessage
implements IMalisisMessageHandler<DeletePacket, IMessage> {
    public AdvertDeleteMessage() {
        MalisisAdvert.network.registerMessage((IMessageHandler)this, DeletePacket.class, Side.SERVER);
        MalisisAdvert.network.registerMessage((IMessageHandler)this, DeletePacket.class, Side.CLIENT);
    }

    public void process(DeletePacket message, MessageContext ctx) {
        Advert advert = ctx.side == Side.SERVER ? ServerAdvert.get(message.id) : ClientAdvert.get(message.id);
        if (advert == null) {
            return;
        }
        advert.delete();
        if (ctx.side == Side.SERVER) {
            AdvertDeleteMessage.sendDelete(advert);
        }
    }

    public static void queryDelete(Advert advert) {
        DeletePacket packet = new DeletePacket(advert);
        MalisisAdvert.network.sendToServer((IMessage)packet);
    }

    public static void sendDelete(Advert advert) {
        DeletePacket packet = new DeletePacket(advert);
        MalisisAdvert.network.sendToAll((IMessage)packet);
    }

    public static class DeletePacket
    implements IMessage {
        private int id;

        public DeletePacket(Advert advert) {
            this.id = advert.getId();
        }

        public DeletePacket() {
        }

        public void fromBytes(ByteBuf buf) {
            this.id = buf.readInt();
        }

        public void toBytes(ByteBuf buf) {
            buf.writeInt(this.id);
        }
    }
}

