/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.client.trackerInfo.detailed;

import pregenerator.base.api.misc.IRenderHelper;
import pregenerator.base.api.network.IReadableBuffer;
import pregenerator.base.api.network.IWriteableBuffer;
import pregenerator.impl.client.trackerInfo.detailed.DetailedEntry;
import pregenerator.impl.tracking.WorldTracker;

public class BlockUpdatesEntry
extends DetailedEntry {
    int value;
    int average;

    public BlockUpdatesEntry() {
        this.register();
    }

    @Override
    public String getName() {
        return "BlockChanges";
    }

    @Override
    public void writeServer(IWriteableBuffer buf) {
        WorldTracker tracker = this.getWorld();
        buf.writeInt(tracker != null ? tracker.getAverageBlockChanges() : 0);
        buf.writeInt(tracker != null ? tracker.getBlockChanges() : 0);
    }

    @Override
    public void readClient(IReadableBuffer buf) {
        this.average = buf.readInt();
        this.value = buf.readInt();
    }

    @Override
    public int getYOffset() {
        return 12;
    }

    @Override
    public void render(int x, int y, float progress, int width, IRenderHelper helper) {
        helper.renderText(x - (width - 25), y, width, "Average BlockChanges: " + this.average);
        helper.renderText(x - (width - 25), y += 6, width, "Current BlockChanges: " + this.value);
    }
}

