/*
 * Decompiled with CFR 0.152.
 */
package com.universeguard.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.universeguard.UniverseGuard;
import com.universeguard.region.GlobalRegion;
import com.universeguard.region.LocalRegion;
import com.universeguard.region.Region;
import com.universeguard.region.components.RegionEffect;
import com.universeguard.region.components.RegionExplosion;
import com.universeguard.region.components.RegionFlag;
import com.universeguard.region.components.RegionInteract;
import com.universeguard.region.components.RegionLocation;
import com.universeguard.region.components.RegionMember;
import com.universeguard.region.components.RegionMob;
import com.universeguard.region.components.RegionVehicle;
import com.universeguard.region.enums.EnumRegionExplosion;
import com.universeguard.region.enums.EnumRegionFlag;
import com.universeguard.region.enums.EnumRegionInteract;
import com.universeguard.region.enums.EnumRegionVehicle;
import com.universeguard.region.enums.RegionEventType;
import com.universeguard.region.enums.RegionPermission;
import com.universeguard.region.enums.RegionRole;
import com.universeguard.region.enums.RegionText;
import com.universeguard.region.enums.RegionType;
import com.universeguard.utils.LogUtils;
import com.universeguard.utils.MessageUtils;
import com.universeguard.utils.PermissionUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.Cancellable;
import org.spongepowered.api.scoreboard.Scoreboard;
import org.spongepowered.api.scoreboard.critieria.Criteria;
import org.spongepowered.api.scoreboard.displayslot.DisplaySlots;
import org.spongepowered.api.scoreboard.objective.Objective;
import org.spongepowered.api.service.user.UserStorageService;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

public class RegionUtils {
    private static HashMap<CommandSource, Region> PENDINGS = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean save(Region region) {
        Gson gson = new GsonBuilder().setPrettyPrinting().serializeNulls().create();
        OutputStreamWriter fileWriter = null;
        try {
            File file;
            File directory;
            File file2 = directory = region.isLocal() ? RegionUtils.getRegionFolder() : RegionUtils.getGlobalRegionFolder();
            if (!directory.exists()) {
                directory.mkdirs();
            }
            if (!(file = RegionUtils.getFile(region)).exists()) {
                file.createNewFile();
            }
            fileWriter = new FileWriter(file);
            fileWriter.write(gson.toJson((Object)region));
            Region cachedRegion = null;
            for (Region cached : UniverseGuard.ALL_REGIONS) {
                if (cached.getId() == null || cached.getId().compareTo(region.getId()) != 0) continue;
                cachedRegion = cached;
                break;
            }
            if (cachedRegion != null) {
                UniverseGuard.ALL_REGIONS.remove(cachedRegion);
            }
            UniverseGuard.ALL_REGIONS.add(region);
            RegionUtils.saveIndex();
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            LogUtils.log(e);
            LogUtils.print(TextColors.RED, RegionText.REGION_SAVE_EXCEPTION.getValue(), "rg utils");
            boolean bl = false;
            return bl;
        }
        finally {
            if (fileWriter != null) {
                try {
                    fileWriter.close();
                }
                catch (IOException e) {
                    LogUtils.log(e);
                    LogUtils.print(RegionText.REGION_WRITER_CLOSE_EXCEPTION.getValue(), "rg utils");
                }
            }
        }
    }

    public static LocalRegion copy(LocalRegion region, String newRegionName) {
        LocalRegion newRegion = new LocalRegion(newRegionName, region.getFirstPoint(), region.getSecondPoint(), region.getTemplate());
        newRegion.setPriority(region.getPriority());
        newRegion.setTeleportLocation(region.getTeleportLocation());
        newRegion.setSpawnLocation(region.getSpawnLocation());
        newRegion.setFarewellMessage(region.getFarewellMessage());
        newRegion.setGreetingMessage(region.getGreetingMessage());
        if (!UniverseGuard.UNIQUE_REGIONS) {
            newRegion.setMembers(region.getMembers());
        }
        newRegion.setFlags(region.getFlags());
        newRegion.setInteracts(region.getInteracts());
        newRegion.setVehicles(region.getVehicles());
        newRegion.setExplosions(region.getExplosions());
        newRegion.setMobs(region.getMobs());
        newRegion.setCommands(region.getCommands());
        return newRegion;
    }

    public static boolean remove(Region region) {
        File directory;
        if (region.isLocal()) {
            ((LocalRegion)region).getMembers().clear();
        }
        File file = directory = region.isLocal() ? RegionUtils.getRegionFolder() : RegionUtils.getGlobalRegionFolder();
        if (!directory.exists()) {
            return false;
        }
        File file2 = RegionUtils.getFile(region);
        if (file2.exists() && file2.delete()) {
            UniverseGuard.ALL_REGIONS.remove(region);
            RegionUtils.saveIndex();
            return true;
        }
        return false;
    }

    public static boolean removeByName(Region region) {
        File directory;
        File file = directory = region.isLocal() ? RegionUtils.getRegionFolder() : RegionUtils.getGlobalRegionFolder();
        if (!directory.exists()) {
            return false;
        }
        File file2 = RegionUtils.getFileByName(region);
        if (file2.exists() && file2.delete()) {
            UniverseGuard.ALL_REGIONS.remove(region);
            RegionUtils.saveIndex();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveIndex() {
        Gson gson = new GsonBuilder().setPrettyPrinting().serializeNulls().create();
        OutputStreamWriter fileWriter = null;
        try {
            File file;
            File directory = new File(RegionUtils.getConfigFolder());
            if (!directory.exists()) {
                directory.mkdirs();
            }
            if (!(file = new File(RegionUtils.getConfigFolder() + "/index.json")).exists()) {
                file.createNewFile();
            }
            fileWriter = new FileWriter(file);
            HashMap<String, UUID> regions = new HashMap<String, UUID>();
            for (Region region : UniverseGuard.ALL_REGIONS) {
                regions.put(region.getName(), region.getId());
            }
            fileWriter.write(gson.toJson(regions));
        }
        catch (IOException e) {
            LogUtils.log(e);
            LogUtils.print(TextColors.RED, RegionText.REGION_SAVE_INDEX_EXCEPTION.getValue(), "rg utils");
        }
        finally {
            if (fileWriter != null) {
                try {
                    fileWriter.close();
                }
                catch (IOException e) {
                    LogUtils.log(e);
                    LogUtils.print(RegionText.REGION_WRITER_INDEX_CLOSE_EXCEPTION.getValue(), "rg utils");
                }
            }
        }
    }

    public static Region load(String name) {
        for (Region region : UniverseGuard.ALL_REGIONS) {
            if (!region.getName().equalsIgnoreCase(name)) continue;
            return region;
        }
        return null;
    }

    public static Region load(UUID id) {
        for (Region region : UniverseGuard.ALL_REGIONS) {
            if (region.getId().compareTo(id) != 0) continue;
            return region;
        }
        return null;
    }

    public static void update(Region region) {
        boolean removeOld = false;
        if (region.isLocal()) {
            LocalRegion newRegion = new LocalRegion(region.getName(), ((LocalRegion)region).getFirstPoint(), ((LocalRegion)region).getSecondPoint(), region.getTemplate());
            newRegion.setMembers(((LocalRegion)region).getMembers());
            newRegion.setPriority(((LocalRegion)region).getPriority());
            if (((LocalRegion)region).getSpawnLocation() != null) {
                newRegion.setSpawnLocation(((LocalRegion)region).getSpawnLocation());
            }
            if (((LocalRegion)region).getTeleportLocation() != null) {
                newRegion.setTeleportLocation(((LocalRegion)region).getTeleportLocation());
            }
            newRegion.setFlags(region.getFlags());
            newRegion.setCommands(region.getCommands());
            newRegion.setInteracts(region.getInteracts());
            newRegion.setVehicles(region.getVehicles());
            newRegion.setExplosions(region.getExplosions());
            newRegion.setMobs(region.getMobs());
            newRegion.setGamemode(region.getGameMode());
            newRegion.setName(region.getName());
            newRegion.updateFlags();
            removeOld = RegionUtils.save(newRegion);
        } else {
            GlobalRegion newRegion = new GlobalRegion(region.getName(), region.getTemplate());
            newRegion.setFlags(region.getFlags());
            newRegion.setGamemode(region.getGameMode());
            newRegion.setCommands(region.getCommands());
            newRegion.setInteracts(region.getInteracts());
            newRegion.setVehicles(region.getVehicles());
            newRegion.setExplosions(region.getExplosions());
            newRegion.setMobs(region.getMobs());
            newRegion.updateFlags();
            removeOld = RegionUtils.save(newRegion);
        }
        if (removeOld) {
            if (region.getId() == null) {
                RegionUtils.removeByName(region);
            } else {
                RegionUtils.remove(region);
            }
        }
    }

    public static ArrayList<Region> getAllRegions() {
        ArrayList<Region> regions = new ArrayList<Region>();
        if (RegionUtils.getRegionFolder().exists()) {
            regions.addAll(RegionUtils.loadRegions(RegionUtils.getRegionFolder(), RegionType.LOCAL));
        }
        if (RegionUtils.getGlobalRegionFolder().exists()) {
            regions.addAll(RegionUtils.loadRegions(RegionUtils.getGlobalRegionFolder(), RegionType.GLOBAL));
        }
        return regions;
    }

    public static boolean shouldConvertOldRegions() {
        return RegionUtils.getOldRegionFolder().exists() || RegionUtils.getOldGlobalRegionFolder().exists();
    }

    public static void convertOldRegions() {
        if (RegionUtils.getOldRegionFolder().exists()) {
            RegionUtils.loadOldRegions(RegionUtils.getOldRegionFolder(), RegionType.LOCAL);
        }
        if (RegionUtils.getOldGlobalRegionFolder().exists()) {
            RegionUtils.loadOldRegions(RegionUtils.getOldGlobalRegionFolder(), RegionType.GLOBAL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static void loadOldRegions(File directory, RegionType type) {
        for (File file : directory.listFiles()) {
            BufferedReader bufferedReader = null;
            try {
                bufferedReader = new BufferedReader(new FileReader(file));
                JsonObject jsonObject = new JsonObject();
                JsonParser parser = new JsonParser();
                JsonElement jsonElement = parser.parse((Reader)new FileReader(file));
                jsonObject = jsonElement.getAsJsonObject();
                for (Map.Entry element : jsonObject.entrySet()) {
                    void var22_39;
                    void var21_32;
                    EnumRegionVehicle[] flagElement;
                    JsonObject jObj = ((JsonElement)element.getValue()).getAsJsonObject();
                    Region region = null;
                    region = type.equals((Object)RegionType.LOCAL) ? new LocalRegion((String)element.getKey()) : new GlobalRegion((String)element.getKey(), false);
                    JsonObject flagObject = jObj.getAsJsonObject("flags");
                    EnumRegionFlag[] enumRegionFlagArray = EnumRegionFlag.values();
                    int n = enumRegionFlagArray.length;
                    for (int i = 0; i < n; ++i) {
                        EnumRegionInteract[] flag;
                        flagElement = flagObject.get((flag = enumRegionFlagArray[i]).getName().toLowerCase());
                        region.setFlag((EnumRegionFlag)flag, flagElement != null ? flagElement.getAsBoolean() : flag.getValue());
                    }
                    JsonElement flagBuildElement = flagObject.get("build");
                    region.setFlag(EnumRegionFlag.PLACE, flagBuildElement != null ? flagBuildElement.getAsBoolean() : EnumRegionFlag.PLACE.getValue());
                    region.setFlag(EnumRegionFlag.DESTROY, flagBuildElement != null ? flagBuildElement.getAsBoolean() : EnumRegionFlag.DESTROY.getValue());
                    JsonElement flagChestsElement = flagObject.get("chests");
                    region.setFlag(EnumRegionFlag.CHESTS, flagChestsElement != null ? flagChestsElement.getAsBoolean() : EnumRegionFlag.CHESTS.getValue());
                    region.setFlag(EnumRegionFlag.TRAPPED_CHESTS, flagChestsElement != null ? flagChestsElement.getAsBoolean() : EnumRegionFlag.TRAPPED_CHESTS.getValue());
                    JsonElement flagUseElement = flagObject.get("use");
                    for (EnumRegionInteract enumRegionInteract : EnumRegionInteract.values()) {
                        region.setInteract(enumRegionInteract, flagUseElement != null ? flagUseElement.getAsBoolean() : enumRegionInteract.getValue());
                    }
                    JsonElement flagVehiclePlaceElement = flagObject.get("vehicleplace");
                    flagElement = EnumRegionVehicle.values();
                    int n2 = flagElement.length;
                    boolean bl = false;
                    while (var21_32 < n2) {
                        EnumRegionVehicle enumRegionVehicle = flagElement[var21_32];
                        region.setVehiclePlace(enumRegionVehicle, flagVehiclePlaceElement != null ? flagVehiclePlaceElement.getAsBoolean() : enumRegionVehicle.getPlace());
                        ++var21_32;
                    }
                    JsonElement flagVehicleDestroyElement = flagObject.get("vehicledestroy");
                    EnumRegionVehicle[] enumRegionVehicleArray = EnumRegionVehicle.values();
                    int n3 = enumRegionVehicleArray.length;
                    boolean bl2 = false;
                    while (var22_39 < n3) {
                        EnumRegionVehicle vehicle3 = enumRegionVehicleArray[var22_39];
                        region.setVehicleDestroy(vehicle3, flagVehicleDestroyElement != null ? flagVehicleDestroyElement.getAsBoolean() : vehicle3.getDestroy());
                        ++var22_39;
                    }
                    JsonElement flagExplosionDestroyElement = flagObject.get("otherexplosions");
                    for (EnumRegionExplosion explosion : EnumRegionExplosion.values()) {
                        region.setExplosionDestroy(explosion, flagExplosionDestroyElement != null ? flagExplosionDestroyElement.getAsBoolean() : explosion.getDestroy());
                    }
                    JsonElement jsonElement2 = flagObject.get("otherexplosionsdamage");
                    for (EnumRegionExplosion explosion2 : EnumRegionExplosion.values()) {
                        region.setExplosionDamage(explosion2, jsonElement2 != null ? jsonElement2.getAsBoolean() : explosion2.getDamage());
                    }
                    JsonElement jsonElement3 = flagObject.get("tnt");
                    region.setExplosionDestroy(EnumRegionExplosion.TNT, jsonElement3 != null ? jsonElement3.getAsBoolean() : EnumRegionExplosion.TNT.getDestroy());
                    JsonElement flagTntDamageElement = flagObject.get("tntdamage");
                    region.setExplosionDamage(EnumRegionExplosion.TNT, flagTntDamageElement != null ? flagTntDamageElement.getAsBoolean() : EnumRegionExplosion.TNT.getDamage());
                    JsonElement flagCreeperElement = flagObject.get("creeperexplosions");
                    region.setExplosionDestroy(EnumRegionExplosion.CREEPER, flagCreeperElement != null ? flagCreeperElement.getAsBoolean() : EnumRegionExplosion.CREEPER.getDestroy());
                    JsonElement flagCreeperDamageElement = flagObject.get("mobdamage");
                    region.setExplosionDamage(EnumRegionExplosion.CREEPER, flagCreeperDamageElement != null ? flagCreeperDamageElement.getAsBoolean() : EnumRegionExplosion.CREEPER.getDamage());
                    if (type.equals((Object)RegionType.LOCAL)) {
                        JsonObject firstPoint = jObj.getAsJsonObject("pos1");
                        JsonObject secondPoint = jObj.getAsJsonObject("pos2");
                        JsonObject teleportPoint = jObj.getAsJsonObject("teleport");
                        JsonObject spawnPoint = jObj.getAsJsonObject("spawn");
                        ((LocalRegion)region).setFirstPoint(new RegionLocation(firstPoint.get("x").getAsInt(), firstPoint.get("y").getAsInt(), firstPoint.get("z").getAsInt(), jObj.get("dimension").getAsString(), jObj.get("world").getAsString()));
                        ((LocalRegion)region).setSecondPoint(new RegionLocation(secondPoint.get("x").getAsInt(), secondPoint.get("y").getAsInt(), secondPoint.get("z").getAsInt(), jObj.get("dimension").getAsString(), jObj.get("world").getAsString()));
                        ((LocalRegion)region).setTeleportLocation(new RegionLocation(teleportPoint.get("x").getAsInt(), teleportPoint.get("y").getAsInt(), teleportPoint.get("z").getAsInt(), jObj.get("dimension").getAsString(), jObj.get("world").getAsString()));
                        ((LocalRegion)region).setSpawnLocation(new RegionLocation(spawnPoint.get("x").getAsInt(), spawnPoint.get("y").getAsInt(), spawnPoint.get("z").getAsInt(), jObj.get("dimension").getAsString(), jObj.get("world").getAsString()));
                        ((LocalRegion)region).setPriority(jObj.get("priority").getAsInt());
                        ((LocalRegion)region).setGamemode(jObj.get("gamemode").getAsString());
                    }
                    RegionUtils.save(region);
                }
            }
            catch (FileNotFoundException e) {
                LogUtils.log(e);
                LogUtils.print(TextColors.RED, RegionText.REGION_LOAD_EXCEPTION.getValue(), "rg utils");
            }
            finally {
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException e) {
                        LogUtils.log(e);
                        LogUtils.print(TextColors.RED, RegionText.REGION_READER_CLOSE_EXCEPTION.getValue(), "rg utils");
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<Region> loadRegions(File directory, RegionType type) {
        ArrayList<Region> regions = new ArrayList<Region>();
        for (File file : directory.listFiles()) {
            Gson gson = new Gson();
            BufferedReader bufferedReader = null;
            try {
                Region region;
                bufferedReader = new BufferedReader(new FileReader(file));
                if (type == RegionType.LOCAL) {
                    region = (LocalRegion)gson.fromJson((Reader)bufferedReader, LocalRegion.class);
                    if (region == null) continue;
                    regions.add(region);
                    continue;
                }
                region = (GlobalRegion)gson.fromJson((Reader)bufferedReader, GlobalRegion.class);
                if (region == null) continue;
                regions.add(region);
            }
            catch (FileNotFoundException e) {
                LogUtils.log(e);
                LogUtils.print(TextColors.RED, RegionText.REGION_LOAD_EXCEPTION.getValue(), "rg utils");
            }
            finally {
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException e) {
                        LogUtils.log(e);
                        LogUtils.print(TextColors.RED, RegionText.REGION_READER_CLOSE_EXCEPTION.getValue(), "rg utils");
                    }
                }
            }
        }
        return regions;
    }

    public static void setPendingRegion(Player player, Region region) {
        if (region == null) {
            PENDINGS.remove(player);
        } else if (!PENDINGS.containsKey(player)) {
            PENDINGS.put((CommandSource)player, region);
        }
    }

    public static void setPendingRegion(CommandSource source, Region region) {
        if (region == null) {
            PENDINGS.remove(source);
        } else if (!PENDINGS.containsKey(source)) {
            PENDINGS.put(source, region);
        }
    }

    public static Region getPendingRegion(Player player) {
        return PENDINGS.get(player);
    }

    public static Region getPendingRegion(CommandSource source) {
        return PENDINGS.get(source);
    }

    public static void updatePendingRegion(Player player, Region region) {
        RegionUtils.setPendingRegion(player, null);
        RegionUtils.setPendingRegion(player, region);
    }

    public static void updatePendingRegion(CommandSource source, Region region) {
        RegionUtils.setPendingRegion(source, null);
        RegionUtils.setPendingRegion(source, region);
        if (source instanceof Player && region.isLocal()) {
            RegionUtils.setRegionScoreboard((Player)source, (LocalRegion)region);
        }
    }

    public static boolean hasPendingRegion(Player player) {
        return RegionUtils.getPendingRegion(player) != null;
    }

    public static boolean hasPendingRegion(CommandSource source) {
        return RegionUtils.getPendingRegion(source) != null;
    }

    public static void printRegionsList(Player player) {
        RegionUtils.printRegionsList((CommandSource)player);
    }

    public static void printRegionsList(CommandSource source) {
        StringBuilder regions = new StringBuilder();
        for (Region region : UniverseGuard.ALL_REGIONS) {
            if (region.getFlag(EnumRegionFlag.HIDE_REGION) || region.getTemplate()) continue;
            regions.append(region.getName() + ", ");
        }
        MessageUtils.sendMessage(source, RegionText.REGION_LIST.getValue(), TextColors.GOLD);
        MessageUtils.sendMessage(source, regions.substring(0, regions.length() - 2), TextColors.YELLOW);
    }

    public static boolean isOnline(UUID uuid) {
        return Sponge.getServer().getPlayer(uuid).isPresent();
    }

    public static void printRegion(CommandSource source, Region region) {
        int i;
        MessageUtils.sendMessage(source, RegionText.REGION_INFO.getValue() + ": " + region.getName(), TextColors.GOLD);
        MessageUtils.sendMessage(source, RegionText.TYPE.getValue() + ": " + region.getType().toString(), TextColors.YELLOW);
        if (region.isLocal()) {
            LocalRegion localRegion = (LocalRegion)region;
            MessageUtils.sendMessage(source, RegionText.PRIORITY.getValue() + ": " + String.valueOf(localRegion.getPriority()), TextColors.YELLOW);
            if (!localRegion.getFarewellMessage().isEmpty()) {
                MessageUtils.sendMessage(source, RegionText.FAREWELL_MESSAGE.getValue() + ": " + localRegion.getFarewellMessage(), TextColors.RED);
            }
            if (!localRegion.getGreetingMessage().isEmpty()) {
                MessageUtils.sendMessage(source, RegionText.GREETING_MESSAGE.getValue() + ": " + localRegion.getGreetingMessage(), TextColors.GREEN);
            }
            if (localRegion.getValue() != null) {
                MessageUtils.sendMessage(source, RegionText.REGION_VALUE.getValue() + ": " + localRegion.getValue().getItem() + " (" + localRegion.getValue().getQuantity() + ")", TextColors.GREEN);
            }
            if (!localRegion.getFlag(EnumRegionFlag.HIDE_LOCATIONS)) {
                MessageUtils.sendMessage(source, RegionText.FROM.getValue() + ": " + localRegion.getFirstPoint().toString(), TextColors.AQUA);
                MessageUtils.sendMessage(source, RegionText.TO.getValue() + ": " + localRegion.getSecondPoint().toString(), TextColors.AQUA);
                MessageUtils.sendMessage(source, RegionText.TELEPORT.getValue() + ": " + localRegion.getTeleportLocation().toString(), TextColors.AQUA);
                MessageUtils.sendMessage(source, RegionText.SPAWN.getValue() + ": " + localRegion.getSpawnLocation().toString(), TextColors.AQUA);
            }
            if (!localRegion.getFlag(EnumRegionFlag.HIDE_MEMBERS)) {
                MessageUtils.sendMessage(source, RegionText.MEMBERS.getValue(), TextColors.YELLOW);
                ArrayList<Text> members = new ArrayList<Text>();
                for (i = 0; i < localRegion.getMembers().size(); ++i) {
                    RegionMember member = localRegion.getMembers().get(i);
                    members.add(Text.of((Object[])new Object[]{source instanceof Player && member.getUUID().equals(((Player)source).getUniqueId()) ? TextColors.AQUA : (RegionUtils.isOnline(member.getUUID()) ? TextColors.GREEN : TextColors.RED), member.getUsername(), i < localRegion.getMembers().size() - 1 ? ", " : ""}));
                }
                source.sendMessage(Text.of((Object[])members.toArray()));
            }
            MessageUtils.sendMessage(source, RegionText.EFFECTS.getValue(), TextColors.YELLOW);
            ArrayList<Text> effects = new ArrayList<Text>();
            for (i = 0; i < localRegion.getEffects().size(); ++i) {
                RegionEffect effect = ((LocalRegion)region).getEffects().get(i);
                effects.add(Text.of((Object[])new Object[]{TextColors.GREEN, effect.getEffect().getTranslation().get(), " ", effect.getLevel() + 1, String.valueOf(i < localRegion.getEffects().size() - 1 ? ", " : "")}));
            }
            source.sendMessage(Text.of((Object[])effects.toArray()));
        }
        if (!region.getFlag(EnumRegionFlag.HIDE_FLAGS)) {
            MessageUtils.sendMessage(source, RegionText.FLAGS.getValue(), TextColors.YELLOW);
            ArrayList<Text> flags = new ArrayList<Text>();
            for (int i2 = 0; i2 < region.getFlags().size(); ++i2) {
                RegionFlag flag = region.getFlags().get(i2);
                flags.add(Text.of((Object[])new Object[]{flag.getValue() ? TextColors.GREEN : TextColors.RED, flag.getName(), i2 < region.getFlags().size() - 1 ? ", " : ""}));
            }
            source.sendMessage(Text.of((Object[])flags.toArray()));
            MessageUtils.sendMessage(source, RegionText.INTERACTS.getValue(), TextColors.YELLOW);
            ArrayList<Text> interacts = new ArrayList<Text>();
            for (i = 0; i < region.getInteracts().size(); ++i) {
                RegionInteract interact = region.getInteracts().get(i);
                interacts.add(Text.of((Object[])new Object[]{interact.isEnabled() ? TextColors.GREEN : TextColors.RED, interact.getBlock(), i < region.getInteracts().size() - 1 ? ", " : ""}));
            }
            source.sendMessage(Text.of((Object[])interacts.toArray()));
            MessageUtils.sendMessage(source, RegionText.EXPLOSIONS_DAMAGE.getValue(), TextColors.YELLOW);
            ArrayList<Text> explosionsDamage = new ArrayList<Text>();
            for (int i3 = 0; i3 < region.getExplosions().size(); ++i3) {
                RegionExplosion explosion = region.getExplosions().get(i3);
                explosionsDamage.add(Text.of((Object[])new Object[]{explosion.getDamage() ? TextColors.GREEN : TextColors.RED, explosion.getExplosion(), i3 < region.getExplosions().size() - 1 ? ", " : ""}));
            }
            source.sendMessage(Text.of((Object[])explosionsDamage.toArray()));
            MessageUtils.sendMessage(source, RegionText.EXPLOSIONS_DESTROY.getValue(), TextColors.YELLOW);
            ArrayList<Text> explosionsDestroy = new ArrayList<Text>();
            for (int i4 = 0; i4 < region.getExplosions().size(); ++i4) {
                RegionExplosion explosion = region.getExplosions().get(i4);
                explosionsDestroy.add(Text.of((Object[])new Object[]{explosion.getDestroy() ? TextColors.GREEN : TextColors.RED, explosion.getExplosion(), i4 < region.getExplosions().size() - 1 ? ", " : ""}));
            }
            source.sendMessage(Text.of((Object[])explosionsDestroy.toArray()));
            MessageUtils.sendMessage(source, RegionText.VEHICLES_PLACE.getValue(), TextColors.YELLOW);
            ArrayList<Text> vehiclesPlace = new ArrayList<Text>();
            for (int i5 = 0; i5 < region.getVehicles().size(); ++i5) {
                RegionVehicle vehicle = region.getVehicles().get(i5);
                vehiclesPlace.add(Text.of((Object[])new Object[]{vehicle.getPlace() ? TextColors.GREEN : TextColors.RED, vehicle.getName(), i5 < region.getVehicles().size() - 1 ? ", " : ""}));
            }
            source.sendMessage(Text.of((Object[])vehiclesPlace.toArray()));
            MessageUtils.sendMessage(source, RegionText.VEHICLES_DESTROY.getValue(), TextColors.YELLOW);
            ArrayList<Text> vehiclesDestroy = new ArrayList<Text>();
            for (int i6 = 0; i6 < region.getVehicles().size(); ++i6) {
                RegionVehicle vehicle = region.getVehicles().get(i6);
                vehiclesDestroy.add(Text.of((Object[])new Object[]{vehicle.getDestroy() ? TextColors.GREEN : TextColors.RED, vehicle.getName(), i6 < region.getVehicles().size() - 1 ? ", " : ""}));
            }
            source.sendMessage(Text.of((Object[])vehiclesDestroy.toArray()));
            if (region.getMobs().size() > 0) {
                MessageUtils.sendMessage(source, RegionText.MOBS_SPAWN.getValue(), TextColors.YELLOW);
                ArrayList<Text> mobsSpawn = new ArrayList<Text>();
                for (int i7 = 0; i7 < region.getMobs().size(); ++i7) {
                    RegionMob mob = region.getMobs().get(i7);
                    mobsSpawn.add(Text.of((Object[])new Object[]{mob.getSpawn() ? TextColors.GREEN : TextColors.RED, mob.getMob(), i7 < region.getMobs().size() - 1 ? ", " : ""}));
                }
                source.sendMessage(Text.of((Object[])mobsSpawn.toArray()));
                MessageUtils.sendMessage(source, RegionText.MOBS_PVE.getValue(), TextColors.YELLOW);
                ArrayList<Text> mobsPve = new ArrayList<Text>();
                for (int i8 = 0; i8 < region.getMobs().size(); ++i8) {
                    RegionMob mob = region.getMobs().get(i8);
                    mobsPve.add(Text.of((Object[])new Object[]{mob.getPve() ? TextColors.GREEN : TextColors.RED, mob.getMob(), i8 < region.getMobs().size() - 1 ? ", " : ""}));
                }
                source.sendMessage(Text.of((Object[])mobsPve.toArray()));
                MessageUtils.sendMessage(source, RegionText.MOBS_DAMAGE.getValue(), TextColors.YELLOW);
                ArrayList<Text> mobsDamage = new ArrayList<Text>();
                for (int i9 = 0; i9 < region.getMobs().size(); ++i9) {
                    RegionMob mob = region.getMobs().get(i9);
                    mobsDamage.add(Text.of((Object[])new Object[]{mob.getDamage() ? TextColors.GREEN : TextColors.RED, mob.getMob(), i9 < region.getMobs().size() - 1 ? ", " : ""}));
                }
                source.sendMessage(Text.of((Object[])mobsDamage.toArray()));
                MessageUtils.sendMessage(source, RegionText.MOBS_DROP.getValue(), TextColors.YELLOW);
                ArrayList<Text> mobsDrop = new ArrayList<Text>();
                for (int i10 = 0; i10 < region.getMobs().size(); ++i10) {
                    RegionMob mob = region.getMobs().get(i10);
                    mobsDrop.add(Text.of((Object[])new Object[]{mob.getDrop() ? TextColors.GREEN : TextColors.RED, mob.getMob(), i10 < region.getMobs().size() - 1 ? ", " : ""}));
                }
                source.sendMessage(Text.of((Object[])mobsDrop.toArray()));
                MessageUtils.sendMessage(source, RegionText.MOBS_INTERACT.getValue(), TextColors.YELLOW);
                ArrayList<Text> mobsInteract = new ArrayList<Text>();
                for (int i11 = 0; i11 < region.getMobs().size(); ++i11) {
                    RegionMob mob = region.getMobs().get(i11);
                    mobsInteract.add(Text.of((Object[])new Object[]{mob.getInteract() ? TextColors.GREEN : TextColors.RED, mob.getMob(), i11 < region.getMobs().size() - 1 ? ", " : ""}));
                }
                source.sendMessage(Text.of((Object[])mobsInteract.toArray()));
            }
        }
    }

    public static Player getPlayer(UUID uuid) {
        Optional onlinePlayer = Sponge.getServer().getPlayer(uuid);
        if (onlinePlayer.isPresent()) {
            return (Player)onlinePlayer.get();
        }
        Optional userStorage = Sponge.getServiceManager().provide(UserStorageService.class);
        if (userStorage.isPresent() && ((UserStorageService)userStorage.get()).get(uuid).isPresent()) {
            if (((User)((UserStorageService)userStorage.get()).get(uuid).get()).getPlayer().isPresent()) {
                return (Player)((User)((UserStorageService)userStorage.get()).get(uuid).get()).getPlayer().get();
            }
            return null;
        }
        return null;
    }

    public static RegionMember getMember(LocalRegion region, Player player) {
        for (RegionMember member : region.getMembers()) {
            if (!member.getUUID().equals(player.getUniqueId())) continue;
            return member;
        }
        return null;
    }

    public static RegionMember getMember(LocalRegion region, UUID player) {
        for (RegionMember member : region.getMembers()) {
            if (!member.getUUID().equals(player)) continue;
            return member;
        }
        return null;
    }

    public static boolean isMemberByUUID(Region region, UUID player) {
        if (region.isLocal()) {
            return RegionUtils.getMember((LocalRegion)region, player) != null;
        }
        return false;
    }

    public static boolean isMember(Region region, Player player) {
        if (region.isLocal()) {
            return RegionUtils.getMember((LocalRegion)region, player) != null;
        }
        return false;
    }

    public static boolean isOwner(Region region, Player player) {
        if (region.isLocal()) {
            return RegionUtils.isMember(region, player) && RegionUtils.getMember((LocalRegion)region, player).getRole().equals((Object)RegionRole.OWNER);
        }
        return false;
    }

    public static boolean hasPermission(Player player, Region region) {
        return PermissionUtils.hasPermission(player, RegionPermission.REGION) || RegionUtils.isMember(region, player);
    }

    public static boolean hasRegion(Player player) {
        for (Region region : UniverseGuard.ALL_REGIONS) {
            if (!RegionUtils.isMember(region, player)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasRegionByUUID(UUID player) {
        for (Region region : UniverseGuard.ALL_REGIONS) {
            if (!RegionUtils.isMemberByUUID(region, player)) continue;
            return true;
        }
        return false;
    }

    public static void printHelpHeader(CommandSource source, int page) {
        MessageUtils.sendMessage(source, RegionText.HELP.getValue() + "(" + String.valueOf(page) + "/5)", TextColors.GOLD);
    }

    public static void printFlagHelpHeader(CommandSource source, int page) {
        MessageUtils.sendMessage(source, RegionText.FLAG_HELP.getValue() + "(" + String.valueOf(page) + "/10)", TextColors.GOLD);
    }

    public static void printHelpFor(CommandSource source, String command, RegionText text) {
        MessageUtils.sendMessage(source, "/rg " + command + " - " + text.getValue(), TextColors.YELLOW);
    }

    public static void printFlagHelpFor(CommandSource source, EnumRegionFlag flag, RegionText text) {
        RegionUtils.printFlagHelpFor(source, flag.getName(), text);
    }

    public static void printFlagHelpFor(CommandSource source, String flag, RegionText text) {
        MessageUtils.sendMessage(source, flag + " - " + text.getValue(), TextColors.YELLOW);
    }

    public static boolean isInRegion(LocalRegion region, Location<World> location) {
        if (region.getTemplate()) {
            return false;
        }
        Location<World> pos1 = region.getFirstPoint().getLocation();
        Location<World> pos2 = region.getSecondPoint().getLocation();
        if (pos1 != null && pos2 != null) {
            int x1 = Math.min(pos1.getBlockX(), pos2.getBlockX());
            int y1 = Math.min(pos1.getBlockY(), pos2.getBlockY());
            int z1 = Math.min(pos1.getBlockZ(), pos2.getBlockZ());
            int x2 = Math.max(pos1.getBlockX(), pos2.getBlockX());
            int y2 = Math.max(pos1.getBlockY(), pos2.getBlockY());
            int z2 = Math.max(pos1.getBlockZ(), pos2.getBlockZ());
            return region.getWorld().equals(location.getExtent()) && region.getFirstPoint().getDimension().equalsIgnoreCase(((World)location.getExtent()).getDimension().getType().getId()) && location.getBlockX() >= x1 && location.getBlockX() <= x2 && location.getBlockY() >= y1 && location.getBlockY() <= y2 && location.getBlockZ() >= z1 && location.getBlockZ() <= z2;
        }
        return false;
    }

    public static Region getRegion(Location<World> location) {
        LocalRegion localRegion = RegionUtils.getLocalRegion(location);
        return localRegion != null ? (localRegion.getTemplate() ? null : localRegion) : RegionUtils.getGlobalRegion(location);
    }

    public static ArrayList<LocalRegion> getAllRegionsAt(Location<World> location) {
        ArrayList<LocalRegion> localRegions = RegionUtils.getAllLocalRegionsAt(location);
        return localRegions;
    }

    public static LocalRegion getLocalRegion(Location<World> location) {
        LocalRegion region = null;
        for (Region r : UniverseGuard.ALL_REGIONS) {
            if (!r.isLocal() || !RegionUtils.isInRegion((LocalRegion)r, location) || region != null && ((LocalRegion)r).getPriority() < region.getPriority()) continue;
            region = (LocalRegion)r;
        }
        return region;
    }

    public static ArrayList<LocalRegion> getAllLocalRegionsAt(Location<World> location) {
        ArrayList<LocalRegion> regions = new ArrayList<LocalRegion>();
        for (Region r : UniverseGuard.ALL_REGIONS) {
            if (!r.isLocal() || !RegionUtils.isInRegion((LocalRegion)r, location) || r.getFlag(EnumRegionFlag.HIDE_REGION)) continue;
            regions.add((LocalRegion)r);
        }
        return regions;
    }

    public static GlobalRegion getGlobalRegion(Location<World> location) {
        GlobalRegion global = (GlobalRegion)RegionUtils.load(((World)location.getExtent()).getName());
        return global != null ? (global.getTemplate() ? null : global) : null;
    }

    public static boolean handleEvent(Cancellable event, EnumRegionFlag flag, Location<World> location, Player player, RegionEventType type) {
        Region region = RegionUtils.getRegion(location);
        return RegionUtils.handleEvent(event, flag, region, player, type);
    }

    private static boolean handleEvent(Cancellable event, EnumRegionFlag flag, Region region, Player player, RegionEventType type) {
        if (region != null) {
            boolean cancel;
            boolean bl = flag.equals((Object)EnumRegionFlag.INVINCIBLE) ? region.getFlag(flag) : (cancel = !region.getFlag(flag));
            if (player != null) {
                if (type.equals((Object)RegionEventType.LOCAL)) {
                    if (region.isLocal()) {
                        cancel = cancel && !RegionUtils.hasPermission(player, region);
                    } else if (PermissionUtils.hasPermission(player, RegionPermission.REGION)) {
                        cancel = false;
                    }
                } else if (PermissionUtils.hasPermission(player, RegionPermission.REGION)) {
                    cancel = false;
                }
            }
            if (cancel) {
                if (event != null) {
                    event.setCancelled(true);
                }
                if (player != null) {
                    MessageUtils.sendHotbarErrorMessage(player, RegionText.NO_PERMISSION_REGION.getValue());
                }
                return true;
            }
        }
        return false;
    }

    public static boolean handleInteract(Cancellable event, EnumRegionInteract interact, Region region, Player player) {
        if (region != null && !region.getInteract(interact) && !RegionUtils.hasPermission(player, region)) {
            event.setCancelled(true);
            MessageUtils.sendHotbarErrorMessage(player, RegionText.NO_PERMISSION_REGION.getValue());
            return true;
        }
        return false;
    }

    public static void printHelpPage(CommandSource source, int page) {
        RegionUtils.printHelpHeader(source, page);
        switch (page) {
            default: {
                RegionUtils.printHelpFor(source, "", RegionText.REGION_HELP_RG);
                RegionUtils.printHelpFor(source, "save", RegionText.REGION_HELP_SAVE);
                RegionUtils.printHelpFor(source, "info [region]", RegionText.REGION_HELP_INFO);
                RegionUtils.printHelpFor(source, "delete [region]", RegionText.REGION_HELP_DELETE);
                RegionUtils.printHelpFor(source, "name [name]", RegionText.REGION_HELP_NAME);
                break;
            }
            case 2: {
                RegionUtils.printHelpFor(source, "list", RegionText.REGION_HELP_LIST);
                RegionUtils.printHelpFor(source, "gamemode [gamemode]", RegionText.REGION_HELP_GAMEMODE);
                RegionUtils.printHelpFor(source, "edit [region]", RegionText.REGION_HELP_EDIT);
                RegionUtils.printHelpFor(source, "flag [subflag] [flag] [value]", RegionText.REGION_HELP_FLAG);
                RegionUtils.printHelpFor(source, "add [role] [player] (region)", RegionText.REGION_HELP_ADD);
                break;
            }
            case 3: {
                RegionUtils.printHelpFor(source, "remove [player] (region)", RegionText.REGION_HELP_REMOVE);
                RegionUtils.printHelpFor(source, "setteleport [x] [y] [z]", RegionText.REGION_HELP_SET_TELEPORT);
                RegionUtils.printHelpFor(source, "setspawn [x] [y] [z]", RegionText.REGION_HELP_SET_SPAWN);
                RegionUtils.printHelpFor(source, "teleport [region]", RegionText.REGION_HELP_TELEPORT);
                RegionUtils.printHelpFor(source, "spawn [region]", RegionText.REGION_HELP_SPAWN);
                break;
            }
            case 4: {
                RegionUtils.printHelpFor(source, "priority [priority]", RegionText.REGION_HELP_PRIORITY);
                RegionUtils.printHelpFor(source, "command [command]", RegionText.REGION_HELP_COMMAND);
                RegionUtils.printHelpFor(source, "expand [direction] (blocks)", RegionText.REGION_HELP_EXPAND);
                RegionUtils.printHelpFor(source, "here", RegionText.REGION_HELP_HERE);
                RegionUtils.printHelpFor(source, "reload", RegionText.REGION_HELP_RELOAD);
                break;
            }
            case 5: {
                RegionUtils.printHelpFor(source, "farewell", RegionText.REGION_HELP_FAREWELL);
                RegionUtils.printHelpFor(source, "greeting", RegionText.REGION_HELP_GREETING);
                RegionUtils.printHelpFor(source, "effectadd [effect] [amplifier]", RegionText.REGION_HELP_EFFECT_ADD);
                RegionUtils.printHelpFor(source, "effectremove [effect]", RegionText.REGION_HELP_EFFECT_REMOVE);
                RegionUtils.printHelpFor(source, "setvalue [region] [item] [quantity]", RegionText.REGION_HELP_SET_VALUE);
                break;
            }
            case 6: {
                RegionUtils.printHelpFor(source, "removevalue [region]", RegionText.REGION_HELP_REMOVE_VALUE);
                RegionUtils.printHelpFor(source, "buy [region]", RegionText.REGION_HELP_BUY);
                RegionUtils.printHelpFor(source, "sell [region]", RegionText.REGION_HELP_SELL);
                RegionUtils.printHelpFor(source, "excludeblock [block] [type]", RegionText.REGION_HELP_EXCLUDE_BLOCK);
                RegionUtils.printHelpFor(source, "includeblock [block] [type]", RegionText.REGION_HELP_INCLUDE_BLOCK);
                break;
            }
            case 7: {
                RegionUtils.printHelpFor(source, "tempplate [value]", RegionText.REGION_HELP_TEMPLATE);
                RegionUtils.printHelpFor(source, "removefarewell", RegionText.REGION_HELP_REMOVEFAREWELL);
                RegionUtils.printHelpFor(source, "removegreeting", RegionText.REGION_HELP_REMOVEGREETING);
                RegionUtils.printHelpFor(source, "itemuse", RegionText.REGION_HELP_ITEMUSE);
                RegionUtils.printHelpFor(source, "globalfor", RegionText.REGION_HELP_GLOBAL_FOR);
                RegionUtils.printHelpFor(source, "help (flag) (page)", RegionText.REGION_HELP_HELP);
            }
        }
    }

    public static void printFlagHelpPage(CommandSource source, int page) {
        RegionUtils.printFlagHelpHeader(source, page);
        switch (page) {
            default: {
                RegionUtils.printFlagHelpFor(source, EnumRegionFlag.PLACE, RegionText.REGION_FLAG_HELP_PLACE);
                RegionUtils.printFlagHelpFor(source, EnumRegionFlag.DESTROY, RegionText.REGION_FLAG_HELP_DESTROY);
                RegionUtils.printFlagHelpFor(source, EnumRegionFlag.PVP, RegionText.REGION_FLAG_HELP_PVP);
                RegionUtils.printFlagHelpFor(source, EnumRegionFlag.EXP_DROP, RegionText.REGION_FLAG_HELP_EXP_DROP);
                RegionUtils.printFlagHelpFor(source, EnumRegionFlag.ITEM_DROP, RegionText.REGION_FLAG_HELP_ITEM_DROP);
                break;
            }
            case 2: {
                RegionUtils.printFlagHelpFor(source, EnumRegionFlag.ENDERPEARL, RegionText.REGION_FLAG_HELP_ENDERPEARL);
                RegionUtils.printFlagHelpFor(source, EnumRegionFlag.SLEEP, RegionText.REGION_FLAG_HELP_SLEEP);
                RegionUtils.printFlagHelpFor(source, EnumRegionFlag.LIGHTER, RegionText.REGION_FLAG_HELP_LIGHTER);
                RegionUtils.printFlagHelpFor(source, EnumRegionFlag.CHESTS, RegionText.REGION_FLAG_HELP_CHESTS);
                RegionUtils.printFlagHelpFor(source, EnumRegionFlag.TRAPPED_CHESTS, RegionText.REGION_FLAG_HELP_TRAPPED_CHESTS);
                break;
            }
            case 3: {
                RegionUtils.printFlagHelpFor(source, EnumRegionFlag.WATER_FLOW, RegionText.REGION_FLAG_HELP_WATER_FLOW);
                RegionUtils.printFlagHelpFor(source, EnumRegionFlag.LAVA_FLOW, RegionText.REGION_FLAG_HELP_LAVA_FLOW);
                RegionUtils.printFlagHelpFor(source, EnumRegionFlag.LEAF_DECAY, RegionText.REGION_FLAG_HELP_LEAF_DECAY);
                RegionUtils.printFlagHelpFor(source, EnumRegionFlag.FIRE_SPREAD, RegionText.REGION_FLAG_HELP_FIRE_SPREAD);
                RegionUtils.printFlagHelpFor(source, EnumRegionFlag.POTION_SPLASH, RegionText.REGION_FLAG_HELP_POTION_SPLASH);
                break;
            }
            case 4: {
                RegionUtils.printFlagHelpFor(source, EnumRegionFlag.FALL_DAMAGE, RegionText.REGION_FLAG_HELP_FALL_DAMAGE);
                RegionUtils.printFlagHelpFor(source, EnumRegionFlag.CAN_TP, RegionText.REGION_FLAG_HELP_CAN_TP);
                RegionUtils.printFlagHelpFor(source, EnumRegionFlag.CAN_SPAWN, RegionText.REGION_FLAG_HELP_CAN_SPAWN);
                RegionUtils.printFlagHelpFor(source, EnumRegionFlag.HUNGER, RegionText.REGION_FLAG_HELP_HUNGER);
                RegionUtils.printFlagHelpFor(source, EnumRegionFlag.ENDER_CHESTS, RegionText.REGION_FLAG_HELP_ENDER_CHESTS);
                break;
            }
            case 5: {
                RegionUtils.printFlagHelpFor(source, EnumRegionFlag.WALL_DAMAGE, RegionText.REGION_FLAG_HELP_WALL_DAMAGE);
                RegionUtils.printFlagHelpFor(source, EnumRegionFlag.DROWN, RegionText.REGION_FLAG_HELP_DROWN);
                RegionUtils.printFlagHelpFor(source, EnumRegionFlag.INVINCIBLE, RegionText.REGION_FLAG_HELP_INVINCIBLE);
                RegionUtils.printFlagHelpFor(source, EnumRegionFlag.CACTUS_DAMAGE, RegionText.REGION_FLAG_HELP_CACTUS_DAMAGE);
                RegionUtils.printFlagHelpFor(source, EnumRegionFlag.FIRE_DAMAGE, RegionText.REGION_FLAG_HELP_FIRE_DAMAGE);
                break;
            }
            case 6: {
                RegionUtils.printFlagHelpFor(source, EnumRegionFlag.HIDE_LOCATIONS, RegionText.REGION_FLAG_HELP_HIDE_LOCATIONS);
                RegionUtils.printFlagHelpFor(source, EnumRegionFlag.HIDE_FLAGS, RegionText.REGION_FLAG_HELP_HIDE_FLAGS);
                RegionUtils.printFlagHelpFor(source, EnumRegionFlag.HIDE_MEMBERS, RegionText.REGION_FLAG_HELP_HIDE_MEMBERS);
                RegionUtils.printFlagHelpFor(source, EnumRegionFlag.SEND_CHAT, RegionText.REGION_FLAG_HELP_SEND_CHAT);
                RegionUtils.printFlagHelpFor(source, EnumRegionFlag.ENDERMAN_GRIEF, RegionText.REGION_FLAG_HELP_ENDERMAN_GRIEF);
                break;
            }
            case 7: {
                RegionUtils.printFlagHelpFor(source, EnumRegionFlag.ENDER_DRAGON_BLOCK_DAMAGE, RegionText.REGION_FLAG_HELP_ENDER_DRAGON_BLOCK_DAMAGE);
                RegionUtils.printFlagHelpFor(source, EnumRegionFlag.ENDER_DRAGON_BLOCK_DAMAGE, RegionText.REGION_FLAG_HELP_ENDER_DRAGON_BLOCK_DAMAGE);
                RegionUtils.printFlagHelpFor(source, "interact", RegionText.REGION_FLAG_HELP_INTERACT);
                RegionUtils.printFlagHelpFor(source, "vehiceplace", RegionText.REGION_FLAG_HELP_VEHICLE_PLACE);
                RegionUtils.printFlagHelpFor(source, "vehicedestroy", RegionText.REGION_FLAG_HELP_VEHICLE_DESTROY);
                break;
            }
            case 8: {
                RegionUtils.printFlagHelpFor(source, "explosiondamage", RegionText.REGION_FLAG_HELP_EXPLOSION_DAMAGE);
                RegionUtils.printFlagHelpFor(source, "explosiondestroy", RegionText.REGION_FLAG_HELP_EXPLOSION_DESTROY);
                RegionUtils.printFlagHelpFor(source, "mobspawn", RegionText.REGION_FLAG_HELP_MOB_SPAWN);
                RegionUtils.printFlagHelpFor(source, "mobdamage", RegionText.REGION_FLAG_HELP_MOB_DAMAGE);
                RegionUtils.printFlagHelpFor(source, "mobpve", RegionText.REGION_FLAG_HELP_MOB_PVE);
                RegionUtils.printFlagHelpFor(source, "mobinteract", RegionText.REGION_FLAG_HELP_MOB_INTERACT);
                break;
            }
            case 9: {
                RegionUtils.printFlagHelpFor(source, EnumRegionFlag.ITEM_PICKUP, RegionText.REGION_FLAG_HELP_ITEM_PICKUP);
                RegionUtils.printFlagHelpFor(source, EnumRegionFlag.OTHER_LIQUIDS_FLOW, RegionText.REGION_FLAG_HELP_OTHER_LIQUIDS_FLOW);
                RegionUtils.printFlagHelpFor(source, EnumRegionFlag.HIDE_REGION, RegionText.REGION_FLAG_HELP_HIDE_REGION);
                RegionUtils.printFlagHelpFor(source, EnumRegionFlag.ICE_MELT, RegionText.REGION_FLAG_HELP_ICE_MELT);
                RegionUtils.printFlagHelpFor(source, EnumRegionFlag.VINES_GROWTH, RegionText.REGION_FLAG_HELP_VINES_GROWTH);
                break;
            }
            case 10: {
                RegionUtils.printFlagHelpFor(source, EnumRegionFlag.EXIT, RegionText.REGION_FLAG_HELP_EXIT);
                RegionUtils.printFlagHelpFor(source, EnumRegionFlag.ENTER, RegionText.REGION_FLAG_HELP_ENTER);
                RegionUtils.printFlagHelpFor(source, EnumRegionFlag.TRAMPLE, RegionText.REGION_FLAG_HELP_TRAMPLE);
                RegionUtils.printFlagHelpFor(source, EnumRegionFlag.SHULKER_BOXES, RegionText.REGION_FLAG_HELP_SHULKER_BOXES);
                RegionUtils.printFlagHelpFor(source, EnumRegionFlag.PISTONS, RegionText.REGION_FLAG_HELP_PISTONS);
                break;
            }
            case 11: {
                RegionUtils.printFlagHelpFor(source, EnumRegionFlag.FROST_WALKER, RegionText.REGION_FLAG_HELP_FROST_WALKER);
                RegionUtils.printFlagHelpFor(source, EnumRegionFlag.FISHING_POLE, RegionText.REGION_FLAG_HELP_FISHING_POLE);
            }
        }
    }

    public static UUID getPlayerUUID(String username) {
        Optional onlinePlayer = Sponge.getServer().getPlayer(username);
        if (onlinePlayer.isPresent()) {
            return ((Player)onlinePlayer.get()).getUniqueId();
        }
        Optional user = ((UserStorageService)Sponge.getServiceManager().provide(UserStorageService.class).get()).get(username);
        if (user.isPresent()) {
            return ((User)user.get()).getUniqueId();
        }
        return null;
    }

    public static void setRegionScoreboard(Player player, LocalRegion region) {
        Scoreboard scoreboard = Scoreboard.builder().build();
        Objective objective = Objective.builder().name("Region").displayName(Text.of((Object[])new Object[]{TextColors.GOLD, "Region"})).criterion(Criteria.DUMMY).build();
        scoreboard.addObjective(objective);
        scoreboard.updateDisplaySlot(objective, DisplaySlots.SIDEBAR);
        objective.getOrCreateScore((Text)Text.of((String)("Type: " + region.getType().name()))).setScore(10);
        if (region.getName() != null && !region.getName().isEmpty()) {
            objective.getOrCreateScore((Text)Text.of((String)("Name: " + region.getName()))).setScore(5);
        }
        if (region.getFirstPoint() != null) {
            objective.getOrCreateScore((Text)Text.of((String)("From: " + region.getFirstPoint().toString()))).setScore(1);
        }
        if (region.getSecondPoint() != null) {
            objective.getOrCreateScore((Text)Text.of((String)("To: " + region.getSecondPoint().toString()))).setScore(0);
        }
        player.setScoreboard(scoreboard);
    }

    public static ArrayList<Region> getPlayerRegions(UUID player) {
        ArrayList<Region> playerRegions = new ArrayList<Region>();
        for (Region region : UniverseGuard.ALL_REGIONS) {
            if (!RegionUtils.isMemberByUUID(region, player)) continue;
            playerRegions.add(region);
        }
        return playerRegions;
    }

    public static int getPlayerMaxRegions(UUID uuid) {
        Player player = RegionUtils.getPlayer(uuid);
        if (player != null) {
            if (player.hasPermission("*")) {
                return UniverseGuard.MAX_PERMISSION_REGIONS.get("*");
            }
            for (RegionPermission permission : RegionPermission.values()) {
                if (!PermissionUtils.hasPermission(player, permission)) continue;
                return UniverseGuard.MAX_PERMISSION_REGIONS.get(permission.getName());
            }
        }
        return UniverseGuard.MAX_REGIONS;
    }

    public static File getFile(Region region) {
        if (region.getName().isEmpty()) {
            int index = 0;
            for (Region r : UniverseGuard.ALL_REGIONS) {
                if (!r.getName().toLowerCase().startsWith("region")) continue;
                ++index;
            }
            region.setName("Region" + String.valueOf(index));
        }
        return new File((region.getType() == RegionType.LOCAL ? RegionUtils.getRegionFolder() : RegionUtils.getGlobalRegionFolder()) + "/" + region.getId().toString() + ".json");
    }

    public static File getFileByName(Region region) {
        if (region.getName().isEmpty()) {
            int index = 0;
            for (Region r : UniverseGuard.ALL_REGIONS) {
                if (!r.getName().toLowerCase().startsWith("region")) continue;
                ++index;
            }
            region.setName("Region" + String.valueOf(index));
        }
        return new File((region.getType() == RegionType.LOCAL ? RegionUtils.getRegionFolder() : RegionUtils.getGlobalRegionFolder()) + "/" + region.getName() + ".json");
    }

    public static File getRegionFolder() {
        return new File(RegionUtils.getConfigFolder() + "/regions");
    }

    public static File getTemplateFolder() {
        return new File(RegionUtils.getConfigFolder() + "/templates");
    }

    public static File getGlobalRegionFolder() {
        return new File(RegionUtils.getConfigFolder() + "/globals");
    }

    public static File getOldRegionFolder() {
        return new File(RegionUtils.getConfigFolder() + "/old/regions");
    }

    public static File getOldGlobalRegionFolder() {
        return new File(RegionUtils.getConfigFolder() + "/old/globals");
    }

    public static String getConfigFolder() {
        return "config/universeguard/";
    }
}

