/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.inputs;

import mekanism.api.infuse.InfuseRegistry;
import mekanism.api.infuse.InfuseType;
import mekanism.common.InfuseStorage;
import mekanism.common.recipe.inputs.IWildInput;
import mekanism.common.recipe.inputs.MachineInput;
import mekanism.common.util.StackUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;

public class InfusionInput
extends MachineInput<InfusionInput>
implements IWildInput<InfusionInput> {
    public InfuseStorage infuse;
    public ItemStack inputStack = ItemStack.field_190927_a;

    public InfusionInput(InfuseStorage storage, ItemStack itemStack) {
        this.infuse = new InfuseStorage(storage.getType(), storage.getAmount());
        this.inputStack = itemStack;
    }

    public InfusionInput(InfuseType infusionType, int required, ItemStack itemStack) {
        this.infuse = new InfuseStorage(infusionType, required);
        this.inputStack = itemStack;
    }

    public InfusionInput() {
    }

    @Override
    public void load(NBTTagCompound nbtTags) {
        this.inputStack = new ItemStack(nbtTags.func_74775_l("input"));
        InfuseType type = InfuseRegistry.get(nbtTags.func_74779_i("infuseType"));
        int amount = nbtTags.func_74762_e("infuseAmount");
        this.infuse = new InfuseStorage(type, amount);
    }

    @Override
    public InfusionInput copy() {
        return new InfusionInput(this.infuse.getType(), this.infuse.getAmount(), this.inputStack.func_77946_l());
    }

    @Override
    public boolean isValid() {
        return this.infuse.getType() != null && !this.inputStack.func_190926_b();
    }

    public boolean use(NonNullList<ItemStack> inventory, int index, InfuseStorage infuseStorage, boolean deplete) {
        ItemStack stack = (ItemStack)inventory.get(index);
        if (InfusionInput.inputContains(stack, this.inputStack) && infuseStorage.contains(this.infuse)) {
            if (deplete) {
                inventory.set(index, (Object)StackUtils.subtract(stack, this.inputStack));
                infuseStorage.subtract(this.infuse);
            }
            return true;
        }
        return false;
    }

    @Override
    public int hashIngredients() {
        return this.infuse.getType().unlocalizedName.hashCode() << 8 | StackUtils.hashItemStack(this.inputStack);
    }

    @Override
    public boolean testEquality(InfusionInput other) {
        if (!this.isValid()) {
            return !other.isValid();
        }
        return this.infuse.getType() == other.infuse.getType() && MachineInput.inputItemMatches(this.inputStack, other.inputStack);
    }

    @Override
    public boolean isInstance(Object other) {
        return other instanceof InfusionInput;
    }

    @Override
    public InfusionInput wildCopy() {
        return new InfusionInput(this.infuse, new ItemStack(this.inputStack.func_77973_b(), this.inputStack.func_190916_E(), Short.MAX_VALUE));
    }
}

