/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.api.context;

import com.google.common.collect.Multimap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import me.lucko.luckperms.api.context.ImmutableContextSet;
import me.lucko.luckperms.api.context.MutableContextSet;
import org.checkerframework.checker.nullness.qual.NonNull;

public interface ContextSet
extends Iterable<Map.Entry<String, String>> {
    public static @NonNull ImmutableContextSet singleton(@NonNull String key, @NonNull String value) {
        return ImmutableContextSet.singleton(key, value);
    }

    public static @NonNull ImmutableContextSet of(@NonNull String key1, @NonNull String value1, @NonNull String key2, @NonNull String value2) {
        return ImmutableContextSet.of(key1, value1, key2, value2);
    }

    public static @NonNull ImmutableContextSet fromEntries(@NonNull Iterable<? extends Map.Entry<String, String>> iterable) {
        return ImmutableContextSet.fromEntries(iterable);
    }

    public static @NonNull ImmutableContextSet fromMap(@NonNull Map<String, String> map) {
        return ImmutableContextSet.fromMap(map);
    }

    public static @NonNull ImmutableContextSet fromMultimap(@NonNull Multimap<String, String> multimap) {
        return ImmutableContextSet.fromMultimap(multimap);
    }

    public static @NonNull ImmutableContextSet fromSet(@NonNull ContextSet contextSet) {
        return ImmutableContextSet.fromSet(contextSet);
    }

    public static @NonNull ImmutableContextSet empty() {
        return ImmutableContextSet.empty();
    }

    public boolean isImmutable();

    public @NonNull ImmutableContextSet makeImmutable();

    public @NonNull MutableContextSet mutableCopy();

    public @NonNull Set<Map.Entry<String, String>> toSet();

    @Deprecated
    public @NonNull Map<String, String> toMap();

    public @NonNull Multimap<String, String> toMultimap();

    @Override
    public @NonNull Iterator<Map.Entry<String, String>> iterator();

    public boolean containsKey(@NonNull String var1);

    public @NonNull Set<String> getValues(@NonNull String var1);

    default public @NonNull Optional<String> getAnyValue(@NonNull String key) {
        return this.getValues(key).stream().findAny();
    }

    public boolean has(@NonNull String var1, @NonNull String var2);

    default public boolean has(@NonNull Map.Entry<String, String> entry) {
        Objects.requireNonNull(entry, "entry");
        return this.has(entry.getKey(), entry.getValue());
    }

    default public boolean isSatisfiedBy(@NonNull ContextSet other) {
        if (this == other) {
            return true;
        }
        Objects.requireNonNull(other, "other");
        if (this.isEmpty()) {
            return true;
        }
        if (other.isEmpty()) {
            return false;
        }
        if (this.size() > other.size()) {
            return false;
        }
        for (Map.Entry<String, String> context : this.toSet()) {
            if (other.has(context)) continue;
            return false;
        }
        return true;
    }

    public boolean isEmpty();

    public int size();
}

