/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.api.delegates.model;

import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.UUID;
import me.lucko.luckperms.api.DataMutateResult;
import me.lucko.luckperms.api.StandardNodeEquality;
import me.lucko.luckperms.api.User;
import me.lucko.luckperms.api.caching.UserData;
import me.lucko.luckperms.common.api.delegates.model.ApiPermissionHolder;
import me.lucko.luckperms.common.model.NodeMapType;
import me.lucko.luckperms.common.node.factory.NodeFactory;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class ApiUser
extends ApiPermissionHolder
implements User {
    private final me.lucko.luckperms.common.model.User handle;

    public static me.lucko.luckperms.common.model.User cast(User u) {
        Preconditions.checkState((boolean)(u instanceof ApiUser), (Object)("Illegal instance " + u.getClass() + " cannot be handled by this implementation."));
        return ((ApiUser)u).getHandle();
    }

    public ApiUser(me.lucko.luckperms.common.model.User handle) {
        super(handle);
        this.handle = handle;
    }

    @Override
    me.lucko.luckperms.common.model.User getHandle() {
        return this.handle;
    }

    @Override
    public @NonNull UUID getUuid() {
        return this.handle.getUuid();
    }

    @Override
    public String getName() {
        return this.handle.getName().orElse(null);
    }

    @Override
    public @NonNull String getPrimaryGroup() {
        return this.handle.getPrimaryGroup().getValue();
    }

    @Override
    public @NonNull DataMutateResult setPrimaryGroup(@NonNull String group) {
        Objects.requireNonNull(group, "group");
        if (this.getPrimaryGroup().equalsIgnoreCase(group)) {
            return DataMutateResult.ALREADY_HAS;
        }
        if (!this.handle.hasPermission(NodeMapType.ENDURING, NodeFactory.buildGroupNode(group.toLowerCase()).build(), StandardNodeEquality.IGNORE_EXPIRY_TIME_AND_VALUE).asBoolean()) {
            return DataMutateResult.FAIL;
        }
        this.handle.getPrimaryGroup().setStoredValue(group.toLowerCase());
        return DataMutateResult.SUCCESS;
    }

    @Override
    public @NonNull UserData getCachedData() {
        return this.handle.getCachedData();
    }

    @Override
    @Deprecated
    public void refreshPermissions() {
    }

    @Override
    @Deprecated
    public void setupDataCache() {
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ApiUser)) {
            return false;
        }
        ApiUser that = (ApiUser)o;
        return this.handle.equals(that.handle);
    }

    public int hashCode() {
        return this.handle.hashCode();
    }
}

