/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.command.abstraction;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import me.lucko.luckperms.common.command.CommandResult;
import me.lucko.luckperms.common.command.abstraction.CommandException;
import me.lucko.luckperms.common.command.abstraction.SharedSubCommand;
import me.lucko.luckperms.common.command.abstraction.SubCommand;
import me.lucko.luckperms.common.command.utils.ArgumentParser;
import me.lucko.luckperms.common.locale.command.LocalizedCommandSpec;
import me.lucko.luckperms.common.locale.message.Message;
import me.lucko.luckperms.common.model.PermissionHolder;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.utils.Predicates;

public class SharedMainCommand<T extends PermissionHolder>
extends SubCommand<T> {
    private final List<SharedSubCommand> secondaryCommands;
    private final boolean user;

    public SharedMainCommand(LocalizedCommandSpec spec, String name, boolean user, List<SharedSubCommand> secondaryCommands) {
        super(spec, name, null, Predicates.alwaysFalse());
        this.secondaryCommands = secondaryCommands;
        this.user = user;
    }

    @Override
    public CommandResult execute(LuckPermsPlugin plugin, Sender sender, T t, List<String> args, String label) {
        CommandResult result;
        if (args.isEmpty()) {
            this.sendUsageDetailed(sender, this.user, label);
            return CommandResult.INVALID_ARGS;
        }
        Optional<SharedSubCommand> o = this.secondaryCommands.stream().filter(s -> s.getName().equalsIgnoreCase((String)args.get(0))).limit(1L).findAny();
        if (!o.isPresent()) {
            Message.COMMAND_NOT_RECOGNISED.send(sender, new Object[0]);
            return CommandResult.INVALID_ARGS;
        }
        SharedSubCommand sub = o.get();
        if (!sub.isAuthorized(sender, this.user)) {
            Message.COMMAND_NO_PERMISSION.send(sender, new Object[0]);
            return CommandResult.NO_PERMISSION;
        }
        ArrayList<String> strippedArgs = new ArrayList<String>();
        if (args.size() > 1) {
            strippedArgs.addAll(args.subList(1, args.size()));
        }
        if (sub.getArgumentCheck().test((Integer)strippedArgs.size())) {
            sub.sendDetailedUsage(sender);
            return CommandResult.INVALID_ARGS;
        }
        try {
            result = sub.execute(plugin, sender, (PermissionHolder)t, (List<String>)strippedArgs, label, this.user ? sub.getUserPermission() : sub.getGroupPermission());
        }
        catch (CommandException e) {
            result = SharedMainCommand.handleException(e, sender, sub);
        }
        return result;
    }

    @Override
    public List<String> tabComplete(LuckPermsPlugin plugin, Sender sender, List<String> args) {
        List subs = this.secondaryCommands.stream().filter(s -> s.isAuthorized(sender, this.user)).collect(Collectors.toList());
        if (args.size() <= 1) {
            if (args.isEmpty() || args.get(0).equalsIgnoreCase("")) {
                return subs.stream().map(m -> m.getName().toLowerCase()).collect(Collectors.toList());
            }
            return subs.stream().map(m -> m.getName().toLowerCase()).filter(s -> s.toLowerCase().startsWith(((String)args.get(0)).toLowerCase())).collect(Collectors.toList());
        }
        Optional<SharedSubCommand> o = subs.stream().filter(s -> s.getName().equalsIgnoreCase((String)args.get(0))).limit(1L).findAny();
        return o.map(cmd -> cmd.tabComplete(plugin, sender, args.subList(1, args.size()))).orElseGet(Collections::emptyList);
    }

    @Override
    public boolean isAuthorized(Sender sender) {
        return this.secondaryCommands.stream().anyMatch(sc -> sc.isAuthorized(sender, this.user));
    }

    private void sendUsageDetailed(Sender sender, boolean user, String label) {
        List subs = this.secondaryCommands.stream().filter(s -> s.isAuthorized(sender, user)).collect(Collectors.toList());
        if (!subs.isEmpty()) {
            if (user) {
                Message.MAIN_COMMAND_USAGE_HEADER.send(sender, this.getName(), String.format("/%s user <user> " + this.getName().toLowerCase(), label));
            } else {
                Message.MAIN_COMMAND_USAGE_HEADER.send(sender, this.getName(), String.format("/%s group <group> " + this.getName().toLowerCase(), label));
            }
            for (SharedSubCommand s2 : subs) {
                s2.sendUsage(sender);
            }
        } else {
            Message.COMMAND_NO_PERMISSION.send(sender, new Object[0]);
        }
    }

    private static CommandResult handleException(CommandException e, Sender sender, SharedSubCommand command) {
        if (e instanceof ArgumentParser.ArgumentException) {
            if (e instanceof ArgumentParser.DetailedUsageException) {
                command.sendDetailedUsage(sender);
                return CommandResult.INVALID_ARGS;
            }
            if (e instanceof ArgumentParser.InvalidServerWorldException) {
                Message.SERVER_WORLD_INVALID_ENTRY.send(sender, new Object[0]);
                return CommandResult.INVALID_ARGS;
            }
            if (e instanceof ArgumentParser.PastDateException) {
                Message.PAST_DATE_ERROR.send(sender, new Object[0]);
                return CommandResult.INVALID_ARGS;
            }
            if (e instanceof ArgumentParser.InvalidDateException) {
                Message.ILLEGAL_DATE_ERROR.send(sender, ((ArgumentParser.InvalidDateException)e).getInvalidDate());
                return CommandResult.INVALID_ARGS;
            }
            if (e instanceof ArgumentParser.InvalidPriorityException) {
                Message.META_INVALID_PRIORITY.send(sender, ((ArgumentParser.InvalidPriorityException)e).getInvalidPriority());
                return CommandResult.INVALID_ARGS;
            }
        }
        e.printStackTrace();
        return CommandResult.FAILURE;
    }
}

