/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.commands.track;

import java.util.List;
import java.util.stream.Collectors;
import me.lucko.luckperms.common.command.CommandResult;
import me.lucko.luckperms.common.command.abstraction.SingleCommand;
import me.lucko.luckperms.common.command.access.CommandPermission;
import me.lucko.luckperms.common.command.utils.MessageUtils;
import me.lucko.luckperms.common.locale.LocaleManager;
import me.lucko.luckperms.common.locale.command.CommandSpec;
import me.lucko.luckperms.common.locale.message.Message;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.utils.Predicates;

public class ListTracks
extends SingleCommand {
    public ListTracks(LocaleManager locale) {
        super(CommandSpec.LIST_TRACKS.localize(locale), "ListTracks", CommandPermission.LIST_TRACKS, Predicates.alwaysFalse());
    }

    @Override
    public CommandResult execute(LuckPermsPlugin plugin, Sender sender, List<String> args, String label) {
        try {
            plugin.getStorage().loadAllTracks().get();
        }
        catch (Exception e) {
            e.printStackTrace();
            Message.TRACKS_LOAD_ERROR.send(sender, new Object[0]);
            return CommandResult.LOADING_ERROR;
        }
        Message.TRACKS_LIST.send(sender, MessageUtils.toCommaSep(plugin.getTrackManager().getAll().keySet().stream().sorted().collect(Collectors.toList())));
        return CommandResult.SUCCESS;
    }
}

