/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.contexts;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import me.lucko.luckperms.api.Contexts;
import me.lucko.luckperms.api.LookupSetting;
import me.lucko.luckperms.api.caching.MetaContexts;
import me.lucko.luckperms.api.context.ContextCalculator;
import me.lucko.luckperms.api.context.ImmutableContextSet;
import me.lucko.luckperms.api.context.MutableContextSet;
import me.lucko.luckperms.api.context.StaticContextCalculator;
import me.lucko.luckperms.common.buffers.ExpiringCache;
import me.lucko.luckperms.common.config.ConfigKeys;
import me.lucko.luckperms.common.contexts.ContextsSupplier;
import me.lucko.luckperms.common.contexts.ProxiedContextCalculator;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import org.checkerframework.checker.nullness.qual.NonNull;

public abstract class ContextManager<T> {
    protected final LuckPermsPlugin plugin;
    private final Class<T> subjectClass;
    private final List<ContextCalculator<? super T>> calculators = new CopyOnWriteArrayList<ContextCalculator<? super T>>();
    private final List<StaticContextCalculator> staticCalculators = new CopyOnWriteArrayList<StaticContextCalculator>();
    private final StaticLookupCache staticLookupCache = new StaticLookupCache();

    protected ContextManager(LuckPermsPlugin plugin, Class<T> subjectClass) {
        this.plugin = plugin;
        this.subjectClass = subjectClass;
    }

    public List<ContextCalculator<? super T>> getCalculators() {
        return ImmutableList.copyOf(this.calculators);
    }

    public List<StaticContextCalculator> getStaticCalculators() {
        return ImmutableList.copyOf(this.staticCalculators);
    }

    public Class<T> getSubjectClass() {
        return this.subjectClass;
    }

    public ImmutableContextSet getApplicableContext(T subject) {
        return this.getCacheFor(subject).getContextSet();
    }

    public Contexts getApplicableContexts(T subject) {
        return this.getCacheFor(subject).getContexts();
    }

    public abstract ContextsSupplier getCacheFor(T var1);

    public ImmutableContextSet getStaticContext() {
        return this.getStaticContexts().getContexts().makeImmutable();
    }

    public Contexts getStaticContexts() {
        return (Contexts)this.staticLookupCache.get();
    }

    public Optional<String> getStaticContextString() {
        Set<Map.Entry<String, String>> entries = this.getStaticContext().toSet();
        if (entries.isEmpty()) {
            return Optional.empty();
        }
        if (entries.stream().anyMatch(pair -> !((String)pair.getKey()).equals("server"))) {
            return Optional.of(entries.stream().map(pair -> (String)pair.getKey() + "=" + (String)pair.getValue()).collect(Collectors.joining(";")));
        }
        return Optional.of(entries.stream().map(Map.Entry::getValue).collect(Collectors.joining(";")));
    }

    public Contexts formContexts(ImmutableContextSet contextSet) {
        return Contexts.of(contextSet, (Set<LookupSetting>)this.plugin.getConfiguration().get(ConfigKeys.LOOKUP_SETTINGS));
    }

    public MetaContexts formMetaContexts(Contexts contexts) {
        return new MetaContexts(contexts, this.plugin.getConfiguration().get(ConfigKeys.PREFIX_FORMATTING_OPTIONS), this.plugin.getConfiguration().get(ConfigKeys.SUFFIX_FORMATTING_OPTIONS));
    }

    public void registerCalculator(ContextCalculator<? super T> calculator) {
        this.calculators.add(0, calculator);
    }

    public void registerStaticCalculator(StaticContextCalculator calculator) {
        this.registerCalculator(calculator);
        this.staticCalculators.add(0, calculator);
    }

    public abstract void invalidateCache(T var1);

    protected Contexts calculate(T subject) {
        MutableContextSet accumulator = MutableContextSet.create();
        for (ContextCalculator<T> calculator : this.calculators) {
            try {
                MutableContextSet ret = calculator.giveApplicableContext(subject, accumulator);
                if (ret == null) {
                    throw new IllegalStateException(calculator.getClass() + " returned a null context set");
                }
                accumulator = ret;
            }
            catch (Exception e) {
                this.plugin.getLogger().warn("An exception was thrown by " + ContextManager.getCalculatorClass(calculator) + " whilst calculating the context of subject " + subject);
                e.printStackTrace();
            }
        }
        return this.formContexts(subject, accumulator.makeImmutable());
    }

    Contexts calculateStatic() {
        MutableContextSet accumulator = MutableContextSet.create();
        for (StaticContextCalculator calculator : this.staticCalculators) {
            try {
                MutableContextSet ret = calculator.giveApplicableContext(accumulator);
                if (ret == null) {
                    throw new IllegalStateException(calculator.getClass() + " returned a null context set");
                }
                accumulator = ret;
            }
            catch (Exception e) {
                this.plugin.getLogger().warn("An exception was thrown by " + ContextManager.getCalculatorClass(calculator) + " whilst calculating static contexts");
                e.printStackTrace();
            }
        }
        return this.formContexts(accumulator.makeImmutable());
    }

    public abstract Contexts formContexts(T var1, ImmutableContextSet var2);

    private static String getCalculatorClass(ContextCalculator<?> calculator) {
        Class<?> calculatorClass = calculator instanceof ProxiedContextCalculator ? ((ProxiedContextCalculator)calculator).getDelegate().getClass() : calculator.getClass();
        return calculatorClass.getName();
    }

    private final class StaticLookupCache
    extends ExpiringCache<Contexts> {
        StaticLookupCache() {
            super(50L, TimeUnit.MILLISECONDS);
        }

        @Override
        public @NonNull Contexts supply() {
            return ContextManager.this.calculateStatic();
        }
    }
}

