/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.primarygroup;

import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import me.lucko.luckperms.api.Contexts;
import me.lucko.luckperms.common.model.User;
import me.lucko.luckperms.common.primarygroup.StoredHolder;
import me.lucko.luckperms.lib.caffeine.cache.Caffeine;
import me.lucko.luckperms.lib.caffeine.cache.LoadingCache;
import org.checkerframework.checker.nullness.qual.NonNull;

public abstract class ContextualHolder
extends StoredHolder {
    private final LoadingCache<Contexts, Optional<String>> cache = Caffeine.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).build(this::calculateValue);

    public ContextualHolder(User user) {
        super(user);
    }

    protected abstract @NonNull Optional<String> calculateValue(Contexts var1);

    public void invalidateCache() {
        this.cache.invalidateAll();
    }

    @Override
    public final String getValue() {
        Contexts contexts = this.user.getPlugin().getContextForUser(this.user).orElse(null);
        if (contexts == null) {
            contexts = this.user.getPlugin().getContextManager().getStaticContexts();
        }
        return ((Optional)Objects.requireNonNull(this.cache.get((Object)contexts))).orElseGet(() -> this.getStoredValue().orElse("default"));
    }
}

