/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.sponge;

import java.util.UUID;
import me.lucko.luckperms.api.Tristate;
import me.lucko.luckperms.common.command.CommandManager;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.sender.SenderFactory;
import me.lucko.luckperms.lib.text.Component;
import me.lucko.luckperms.lib.text.serializer.ComponentSerializers;
import me.lucko.luckperms.sponge.service.CompatibilityUtil;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.text.serializer.TextSerializers;

public class SpongeSenderFactory
extends SenderFactory<CommandSource> {
    public SpongeSenderFactory(LuckPermsPlugin plugin) {
        super(plugin);
    }

    @Override
    protected String getName(CommandSource source) {
        if (source instanceof Player) {
            return source.getName();
        }
        return "Console";
    }

    @Override
    protected UUID getUuid(CommandSource source) {
        if (source instanceof Player) {
            return ((Player)source).getUniqueId();
        }
        return CommandManager.CONSOLE_UUID;
    }

    @Override
    protected void sendMessage(CommandSource source, String s) {
        source.sendMessage(TextSerializers.LEGACY_FORMATTING_CODE.deserialize(s));
    }

    @Override
    protected void sendMessage(CommandSource source, Component message) {
        source.sendMessage(TextSerializers.JSON.deserialize((String)ComponentSerializers.JSON.serialize(message)));
    }

    @Override
    protected Tristate getPermissionValue(CommandSource source, String node) {
        Tristate ret = CompatibilityUtil.convertTristate(source.getPermissionValue(source.getActiveContexts(), node));
        if (ret == Tristate.UNDEFINED && source.hasPermission(node)) {
            ret = Tristate.TRUE;
        }
        return ret;
    }

    @Override
    protected boolean hasPermission(CommandSource source, String node) {
        return source.hasPermission(node);
    }
}

