/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.sponge.commands;

import java.util.List;
import me.lucko.luckperms.api.context.ImmutableContextSet;
import me.lucko.luckperms.common.command.CommandResult;
import me.lucko.luckperms.common.command.abstraction.SubCommand;
import me.lucko.luckperms.common.command.access.CommandPermission;
import me.lucko.luckperms.common.command.utils.ArgumentParser;
import me.lucko.luckperms.common.command.utils.MessageUtils;
import me.lucko.luckperms.common.locale.LocaleManager;
import me.lucko.luckperms.common.locale.command.CommandSpec;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.utils.Predicates;
import me.lucko.luckperms.sponge.commands.SpongeCommandUtils;
import me.lucko.luckperms.sponge.service.model.LPSubjectData;

public class OptionUnset
extends SubCommand<LPSubjectData> {
    public OptionUnset(LocaleManager locale) {
        super(CommandSpec.SPONGE_OPTION_UNSET.localize(locale), "unset", CommandPermission.SPONGE_OPTION_UNSET, Predicates.is(0));
    }

    @Override
    public CommandResult execute(LuckPermsPlugin plugin, Sender sender, LPSubjectData subjectData, List<String> args, String label) {
        String key = args.get(0);
        ImmutableContextSet contextSet = ArgumentParser.parseContextSponge(1, args);
        if (subjectData.unsetOption(contextSet, key).join().booleanValue()) {
            MessageUtils.sendPluginMessage(sender, "&aUnset &f\"" + key + "&f\"&a in context " + SpongeCommandUtils.contextToString(contextSet, plugin.getLocaleManager()));
        } else {
            MessageUtils.sendPluginMessage(sender, "Unable to unset option. Are you sure the Subject has it set?");
        }
        return CommandResult.SUCCESS;
    }
}

