/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.sponge.commands;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import me.lucko.luckperms.api.context.ContextSet;
import me.lucko.luckperms.api.context.ImmutableContextSet;
import me.lucko.luckperms.common.command.CommandResult;
import me.lucko.luckperms.common.command.abstraction.SubCommand;
import me.lucko.luckperms.common.command.access.CommandPermission;
import me.lucko.luckperms.common.command.utils.ArgumentParser;
import me.lucko.luckperms.common.command.utils.MessageUtils;
import me.lucko.luckperms.common.locale.LocaleManager;
import me.lucko.luckperms.common.locale.command.CommandSpec;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.utils.Predicates;
import me.lucko.luckperms.sponge.commands.SpongeCommandUtils;
import me.lucko.luckperms.sponge.service.model.LPSubjectData;
import me.lucko.luckperms.sponge.service.model.LPSubjectReference;

public class ParentInfo
extends SubCommand<LPSubjectData> {
    public ParentInfo(LocaleManager locale) {
        super(CommandSpec.SPONGE_PARENT_INFO.localize(locale), "info", CommandPermission.SPONGE_PARENT_INFO, Predicates.alwaysFalse());
    }

    @Override
    public CommandResult execute(LuckPermsPlugin plugin, Sender sender, LPSubjectData subjectData, List<String> args, String label) {
        ImmutableContextSet contextSet = ArgumentParser.parseContextSponge(0, args);
        if (contextSet.isEmpty()) {
            MessageUtils.sendPluginMessage(sender, "&aShowing parents matching contexts &bANY&a.");
            ImmutableMap<ImmutableContextSet, ImmutableList<LPSubjectReference>> parents = subjectData.getAllParents();
            if (parents.isEmpty()) {
                MessageUtils.sendPluginMessage(sender, "That subject does not have any parents defined.");
                return CommandResult.SUCCESS;
            }
            for (Map.Entry e : parents.entrySet()) {
                MessageUtils.sendPluginMessage(sender, "&3>> &bContext: " + SpongeCommandUtils.contextToString((ContextSet)e.getKey(), plugin.getLocaleManager()) + "\n" + SpongeCommandUtils.parentsToString((Iterable)e.getValue()));
            }
        } else {
            ImmutableList<LPSubjectReference> parents = subjectData.getParents(contextSet);
            if (parents.isEmpty()) {
                MessageUtils.sendPluginMessage(sender, "That subject does not have any parents defined in those contexts.");
                return CommandResult.SUCCESS;
            }
            MessageUtils.sendPluginMessage(sender, "&aShowing parents matching contexts &b" + SpongeCommandUtils.contextToString(contextSet, plugin.getLocaleManager()) + "&a.\n" + SpongeCommandUtils.parentsToString(parents));
        }
        return CommandResult.SUCCESS;
    }
}

