/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.sponge.service;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import me.lucko.luckperms.common.contexts.ContextManager;
import me.lucko.luckperms.common.utils.Predicates;
import me.lucko.luckperms.lib.caffeine.cache.Caffeine;
import me.lucko.luckperms.lib.caffeine.cache.LoadingCache;
import me.lucko.luckperms.sponge.LPSpongePlugin;
import me.lucko.luckperms.sponge.contexts.SpongeProxiedContextCalculator;
import me.lucko.luckperms.sponge.managers.SpongeGroupManager;
import me.lucko.luckperms.sponge.managers.SpongeUserManager;
import me.lucko.luckperms.sponge.service.misc.SimplePermissionDescription;
import me.lucko.luckperms.sponge.service.model.LPPermissionDescription;
import me.lucko.luckperms.sponge.service.model.LPPermissionService;
import me.lucko.luckperms.sponge.service.model.LPSubject;
import me.lucko.luckperms.sponge.service.model.LPSubjectCollection;
import me.lucko.luckperms.sponge.service.persisted.DefaultsCollection;
import me.lucko.luckperms.sponge.service.persisted.PersistedCollection;
import me.lucko.luckperms.sponge.service.persisted.SubjectStorage;
import me.lucko.luckperms.sponge.service.proxy.ProxyFactory;
import me.lucko.luckperms.sponge.service.reference.SubjectReferenceFactory;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.service.context.ContextCalculator;
import org.spongepowered.api.service.permission.PermissionService;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.text.Text;

public class LuckPermsService
implements LPPermissionService {
    private final LPSpongePlugin plugin;
    private final PermissionService spongeProxy;
    private final SubjectReferenceFactory referenceFactory;
    private final SubjectStorage storage;
    private final DefaultsCollection defaultSubjects;
    private final Map<String, LPPermissionDescription> permissionDescriptions;
    private final LoadingCache<String, LPSubjectCollection> collections = Caffeine.newBuilder().build(s -> new PersistedCollection(this, (String)s));

    public LuckPermsService(LPSpongePlugin plugin) {
        this.plugin = plugin;
        this.referenceFactory = new SubjectReferenceFactory(this);
        this.spongeProxy = ProxyFactory.toSponge(this);
        this.permissionDescriptions = new ConcurrentHashMap<String, LPPermissionDescription>();
        this.storage = new SubjectStorage(this, plugin.getBootstrap().getDataDirectory().resolve("sponge-data"));
        this.defaultSubjects = new DefaultsCollection(this);
        this.defaultSubjects.loadAll();
        this.collections.put((Object)"user", (Object)plugin.getUserManager());
        this.collections.put((Object)"group", (Object)plugin.getGroupManager());
        this.collections.put((Object)"defaults", (Object)this.defaultSubjects);
        for (String identifier : this.storage.getSavedCollections()) {
            if (this.collections.asMap().containsKey(identifier.toLowerCase())) continue;
            PersistedCollection collection = new PersistedCollection(this, identifier.toLowerCase());
            collection.loadAll();
            this.collections.put((Object)collection.getIdentifier(), (Object)collection);
        }
    }

    @Override
    public PermissionService sponge() {
        return this.spongeProxy;
    }

    @Override
    public LPSpongePlugin getPlugin() {
        return this.plugin;
    }

    @Override
    public ContextManager<Subject> getContextManager() {
        return this.plugin.getContextManager();
    }

    @Override
    public SubjectReferenceFactory getReferenceFactory() {
        return this.referenceFactory;
    }

    public SubjectStorage getStorage() {
        return this.storage;
    }

    @Override
    public SpongeUserManager getUserSubjects() {
        return this.plugin.getUserManager();
    }

    @Override
    public SpongeGroupManager getGroupSubjects() {
        return this.plugin.getGroupManager();
    }

    @Override
    public DefaultsCollection getDefaultSubjects() {
        return this.defaultSubjects;
    }

    @Override
    public LPSubject getRootDefaults() {
        return this.defaultSubjects.getRootSubject();
    }

    @Override
    public Predicate<String> getIdentifierValidityPredicate() {
        return Predicates.alwaysTrue();
    }

    @Override
    public LPSubjectCollection getCollection(String s) {
        Objects.requireNonNull(s);
        return (LPSubjectCollection)this.collections.get((Object)s.toLowerCase());
    }

    @Override
    public ImmutableMap<String, LPSubjectCollection> getLoadedCollections() {
        return ImmutableMap.copyOf((Map)this.collections.asMap());
    }

    @Override
    public LPPermissionDescription registerPermissionDescription(String id, Text description, PluginContainer owner) {
        SimplePermissionDescription desc = new SimplePermissionDescription(this, id, description, owner);
        this.permissionDescriptions.put(id, desc);
        this.plugin.getPermissionRegistry().insert(id);
        return desc;
    }

    @Override
    public Optional<LPPermissionDescription> getDescription(String s) {
        Objects.requireNonNull(s);
        return Optional.ofNullable(this.permissionDescriptions.get(s));
    }

    public ImmutableSet<LPPermissionDescription> getDescriptions() {
        HashMap<String, LPPermissionDescription> descriptions = new HashMap<String, LPPermissionDescription>(this.permissionDescriptions);
        for (String perm : this.plugin.getPermissionRegistry().rootAsList()) {
            if (descriptions.containsKey(perm)) continue;
            descriptions.put(perm, new SimplePermissionDescription(this, perm, null, null));
        }
        return ImmutableSet.copyOf(descriptions.values());
    }

    @Override
    public void registerContextCalculator(ContextCalculator<Subject> calculator) {
        Objects.requireNonNull(calculator);
        this.plugin.getContextManager().registerCalculator(new SpongeProxiedContextCalculator(calculator));
    }

    @Override
    public void invalidateAllCaches() {
        for (LPSubjectCollection collection : this.collections.asMap().values()) {
            for (LPSubject subject : collection.getLoadedSubjects()) {
                subject.invalidateCaches();
            }
        }
    }
}

