/*
 * Decompiled with CFR 0.152.
 */
package info.openmods.calc.parsing;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import info.openmods.calc.parsing.InvalidTokenException;
import info.openmods.calc.parsing.token.Token;
import java.util.Iterator;
import org.apache.commons.lang3.tuple.Pair;

public abstract class PositionalNotationParser<I, F> {
    private static final Splitter DOT_SPLITTER = Splitter.on((char)'.');
    private static final PartParser SIMPLE_DIGIT_PART_PARSER = new PartParser(){

        @Override
        public <E> E parsePart(Accumulator<E> accumulator, String input, int radix) {
            char[] charArray;
            for (char ch : charArray = input.toCharArray()) {
                if (ch == '_') continue;
                int digit = Character.digit(ch, radix);
                if (digit < 0) {
                    throw PositionalNotationParser.invalidDigit(input, radix, Character.valueOf(ch));
                }
                accumulator.add(digit);
            }
            return accumulator.get();
        }
    };
    private static final PartParser QUOTED_DIGIT_PART_PARSER = new PartParser(){

        @Override
        public <E> E parsePart(Accumulator<E> accumulator, String input, int radix) {
            String reminder = input;
            int digitRange = Math.min(36, radix);
            while (!reminder.isEmpty()) {
                int digit;
                char ch = reminder.charAt(0);
                reminder = reminder.substring(1);
                if (ch == '_') continue;
                if (ch == '\'') {
                    int nextQuote = reminder.indexOf(39);
                    if (nextQuote < 0) {
                        throw new NumberFormatException("Unmatched quote in " + input);
                    }
                    String digitStr = reminder.substring(0, nextQuote);
                    digit = Integer.parseInt(digitStr);
                    if (digit >= radix) {
                        throw PositionalNotationParser.invalidDigit(input, radix, digitStr);
                    }
                    reminder = reminder.substring(nextQuote + 1);
                } else {
                    digit = Character.digit(ch, digitRange);
                    if (digit < 0) {
                        throw PositionalNotationParser.invalidDigit(input, radix, Character.valueOf(ch));
                    }
                }
                accumulator.add(digit);
            }
            return accumulator.get();
        }
    };

    protected abstract Accumulator<I> createIntegerAccumulator(int var1);

    protected abstract Accumulator<F> createFractionalAccumulator(int var1);

    private Pair<I, F> parseNumber(PartParser partParser, String value, int radix) {
        Iterator parts = DOT_SPLITTER.split((CharSequence)value).iterator();
        Preconditions.checkState((boolean)parts.hasNext(), (String)"Invalid input '%s'", (Object)value);
        String integerPart = (String)parts.next();
        Accumulator<I> integerAccumulator = this.createIntegerAccumulator(radix);
        I integer = partParser.parsePart(integerAccumulator, integerPart, radix);
        if (!parts.hasNext()) {
            return Pair.of(integer, null);
        }
        String fractionalPart = (String)parts.next();
        Accumulator<F> fractionalAccumulator = this.createFractionalAccumulator(radix);
        F fraction = partParser.parsePart(fractionalAccumulator, fractionalPart, radix);
        Preconditions.checkState((!parts.hasNext() ? 1 : 0) != 0, (String)"More than one comman in '%s'", (Object)value);
        return Pair.of(integer, fraction);
    }

    private Pair<I, F> parseSimpleNumber(String value, int radix) {
        return this.parseNumber(SIMPLE_DIGIT_PART_PARSER, value, radix);
    }

    private Pair<I, F> parseQuotedNumber(String value, int radix) {
        return this.parseNumber(QUOTED_DIGIT_PART_PARSER, value.replace("\"", "''"), radix);
    }

    private Pair<I, F> parseQuotedNumber(String value) {
        int radixEnd = value.indexOf(35);
        String radixStr = value.substring(0, radixEnd);
        if (radixStr.isEmpty()) {
            throw new NumberFormatException("No radix given");
        }
        int radix = Integer.parseInt(radixStr);
        if (radix < 2) {
            throw new NumberFormatException("Base must be larger than 2");
        }
        String numberStr = value.substring(radixEnd + 1);
        return this.parseQuotedNumber(numberStr, radix);
    }

    public Pair<I, F> parseString(String value, int radix) {
        if (radix < 2) {
            throw new NumberFormatException("Base must be larger than 2");
        }
        return this.parseQuotedNumber(value, radix);
    }

    public Pair<I, F> parseToken(Token token) {
        switch (token.type) {
            case BIN_NUMBER: {
                return this.parseSimpleNumber(token.value, 2);
            }
            case OCT_NUMBER: {
                return this.parseSimpleNumber(token.value, 8);
            }
            case DEC_NUMBER: {
                return this.parseSimpleNumber(token.value, 10);
            }
            case HEX_NUMBER: {
                return this.parseSimpleNumber(token.value, 16);
            }
            case QUOTED_NUMBER: {
                return this.parseQuotedNumber(token.value);
            }
        }
        throw new InvalidTokenException(token);
    }

    private static NumberFormatException invalidDigit(String value, int radix, Object ch) {
        return new NumberFormatException(String.format("Number '%s' in base %d contains invalid digit '%s'", value, radix, ch));
    }

    private static interface PartParser {
        public <E> E parsePart(Accumulator<E> var1, String var2, int var3);
    }

    public static interface Accumulator<E> {
        public void add(int var1);

        public E get();
    }
}

