/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.blocks;

import com.google.common.base.Predicate;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.blocks.BlockAdvancedTile;
import micdoodle8.mods.galacticraft.core.blocks.ISortableBlock;
import micdoodle8.mods.galacticraft.core.items.IShiftDescription;
import micdoodle8.mods.galacticraft.core.tile.TileEntityCargoLoader;
import micdoodle8.mods.galacticraft.core.tile.TileEntityCargoUnloader;
import micdoodle8.mods.galacticraft.core.util.EnumSortCategoryBlock;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.core.util.WorldUtil;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockCargoLoader
extends BlockAdvancedTile
implements IShiftDescription,
ISortableBlock {
    public static final PropertyEnum<EnumLoaderType> TYPE = PropertyEnum.func_177709_a((String)"type", EnumLoaderType.class);
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    public static final int METADATA_CARGO_LOADER = 0;
    public static final int METADATA_CARGO_UNLOADER = 4;

    public BlockCargoLoader(String assetName) {
        super(Material.field_151576_e);
        this.func_149711_c(1.0f);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_149663_c(assetName);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        list.add((Object)new ItemStack((Block)this, 1, 0));
        list.add((Object)new ItemStack((Block)this, 1, 4));
    }

    public CreativeTabs func_149708_J() {
        return GalacticraftCore.galacticraftBlocksTab;
    }

    @Override
    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        super.func_176213_c(worldIn, pos, state);
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity != null) {
            if (tileEntity instanceof TileEntityCargoLoader) {
                ((TileEntityCargoLoader)tileEntity).checkForCargoEntity();
            } else if (tileEntity instanceof TileEntityCargoUnloader) {
                ((TileEntityCargoUnloader)tileEntity).checkForCargoEntity();
            }
        }
    }

    @Override
    public boolean onMachineActivated(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        playerIn.openGui((Object)GalacticraftCore.instance, -1, worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        if (state.func_177229_b(TYPE) == EnumLoaderType.CARGO_LOADER) {
            return new TileEntityCargoLoader();
        }
        return new TileEntityCargoUnloader();
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        int angle = MathHelper.func_76128_c((double)((double)(placer.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        worldIn.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)angle).func_176734_d()), 3);
        WorldUtil.markAdjacentPadForUpdate(worldIn, pos);
    }

    public void func_176206_d(World worldIn, BlockPos pos, IBlockState state) {
        super.func_176206_d(worldIn, pos, state);
        WorldUtil.markAdjacentPadForUpdate(worldIn, pos);
    }

    public int func_180651_a(IBlockState state) {
        return ((EnumLoaderType)((Object)state.func_177229_b(TYPE))).getMeta();
    }

    @Override
    public String getShiftDescription(int meta) {
        switch (meta) {
            case 0: {
                return GCCoreUtil.translate("tile.cargo_loader.description");
            }
            case 4: {
                return GCCoreUtil.translate("tile.cargo_unloader.description");
            }
        }
        return "";
    }

    @Override
    public boolean showDescription(int meta) {
        return true;
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = EnumFacing.func_176731_b((int)(meta % 4));
        EnumLoaderType type = meta >= 4 ? EnumLoaderType.CARGO_UNLOADER : EnumLoaderType.CARGO_LOADER;
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing).func_177226_a(TYPE, (Comparable)((Object)type));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b() + ((EnumLoaderType)((Object)state.func_177229_b(TYPE))).getMeta();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, TYPE});
    }

    @Override
    public EnumSortCategoryBlock getCategory(int meta) {
        return EnumSortCategoryBlock.MACHINE;
    }

    private static enum EnumLoaderType implements IStringSerializable
    {
        CARGO_LOADER(0, "cargo_loader"),
        CARGO_UNLOADER(4, "cargo_unloader");

        private final int meta;
        private final String name;

        private EnumLoaderType(int meta, String name) {
            this.meta = meta;
            this.name = name;
        }

        public int getMeta() {
            return this.meta;
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

