/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.util.weighted;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.spongepowered.api.util.weighted.RandomObjectTable;

public class LootTable<T> {
    private List<RandomObjectTable<T>> pool = new ArrayList<RandomObjectTable<T>>();

    public void addTable(RandomObjectTable<T> table) {
        this.pool.add((RandomObjectTable<T>)Preconditions.checkNotNull(table));
    }

    public void addAll(LootTable<T> other) {
        this.pool.addAll(other.pool);
    }

    public boolean removeTable(RandomObjectTable<T> table) {
        return this.pool.remove(table);
    }

    public List<RandomObjectTable<T>> getTables() {
        return ImmutableList.copyOf(this.pool);
    }

    public void clearPool() {
        this.pool.clear();
    }

    public List<T> get(Random rand) {
        ArrayList results = Lists.newArrayList();
        for (RandomObjectTable<T> pool : this.pool) {
            results.addAll(pool.get(rand));
        }
        return results;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LootTable)) {
            return false;
        }
        LootTable c = (LootTable)o;
        if (this.pool.size() != c.pool.size()) {
            return false;
        }
        for (int i = 0; i < this.pool.size(); ++i) {
            if (this.pool.get(i).equals(c.pool.get(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int r = 1;
        for (RandomObjectTable<T> table : this.pool) {
            r = r * 37 + table.hashCode();
        }
        return r;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("pool", this.pool).toString();
    }
}

