/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.data.item;

import java.util.List;
import java.util.Optional;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.item.ImmutableCoalData;
import org.spongepowered.api.data.manipulator.mutable.item.CoalData;
import org.spongepowered.api.data.type.CoalType;
import org.spongepowered.api.data.type.CoalTypes;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.api.data.value.mutable.Value;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.data.manipulator.mutable.item.SpongeCoalData;
import org.spongepowered.common.data.processor.common.AbstractItemSingleDataProcessor;
import org.spongepowered.common.data.value.immutable.ImmutableSpongeValue;
import org.spongepowered.common.data.value.mutable.SpongeValue;
import org.spongepowered.common.item.SpongeCoalType;

public class CoalDataProcessor
extends AbstractItemSingleDataProcessor<CoalType, Value<CoalType>, CoalData, ImmutableCoalData> {
    public CoalDataProcessor() {
        super((ItemStack stack) -> stack.func_77973_b().equals(Items.field_151044_h), Keys.COAL_TYPE);
    }

    @Override
    protected CoalData createManipulator() {
        return new SpongeCoalData();
    }

    @Override
    protected boolean set(ItemStack itemStack, CoalType value) {
        itemStack.func_77964_b(((SpongeCoalType)value).type);
        return true;
    }

    @Override
    protected Optional<CoalType> getVal(ItemStack itemStack) {
        int coalmeta = itemStack.func_77952_i();
        List coalTypes = (List)SpongeImpl.getRegistry().getAllOf(CoalType.class);
        return Optional.ofNullable(coalTypes.get(coalmeta));
    }

    @Override
    protected Value<CoalType> constructValue(CoalType actualValue) {
        return new SpongeValue<CoalType>(Keys.COAL_TYPE, CoalTypes.COAL, actualValue);
    }

    @Override
    protected ImmutableValue<CoalType> constructImmutableValue(CoalType value) {
        return ImmutableSpongeValue.cachedOf(Keys.COAL_TYPE, CoalTypes.COAL, value);
    }

    @Override
    public DataTransactionResult removeFrom(ValueContainer<?> container) {
        return DataTransactionResult.failNoData();
    }
}

