/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.value.entity;

import java.util.Optional;
import net.minecraft.entity.EntityAreaEffectCloud;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.api.data.value.mutable.Value;
import org.spongepowered.api.util.Color;
import org.spongepowered.common.data.processor.common.AbstractSpongeValueProcessor;
import org.spongepowered.common.data.value.mutable.SpongeValue;

public class AreaEffectCloudColorProcessor
extends AbstractSpongeValueProcessor<EntityAreaEffectCloud, Color, Value<Color>> {
    public AreaEffectCloudColorProcessor() {
        super(EntityAreaEffectCloud.class, Keys.AREA_EFFECT_CLOUD_COLOR);
    }

    @Override
    protected Value<Color> constructValue(Color actualValue) {
        return new SpongeValue<Color>(Keys.AREA_EFFECT_CLOUD_COLOR, Color.WHITE, actualValue);
    }

    @Override
    protected boolean set(EntityAreaEffectCloud container, Color value) {
        container.func_184482_a(value.getRgb());
        return true;
    }

    @Override
    protected Optional<Color> getVal(EntityAreaEffectCloud container) {
        return Optional.of(Color.ofRgb(container.func_184492_k()));
    }

    @Override
    protected ImmutableValue<Color> constructImmutableValue(Color value) {
        return this.constructValue(value).asImmutable();
    }

    @Override
    public DataTransactionResult removeFrom(ValueContainer<?> container) {
        return DataTransactionResult.failNoData();
    }
}

