/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.inventory.adapter.impl.slots;

import com.google.common.collect.ImmutableList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Optional;
import net.minecraft.inventory.Container;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.item.ItemTypes;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.Slot;
import org.spongepowered.api.item.inventory.transaction.InventoryTransactionResult;
import org.spongepowered.common.item.inventory.adapter.impl.AbstractInventoryAdapter;
import org.spongepowered.common.item.inventory.lens.Fabric;
import org.spongepowered.common.item.inventory.lens.slots.SlotLens;
import org.spongepowered.common.item.inventory.util.ItemStackUtil;

public class SlotAdapter
extends AbstractInventoryAdapter
implements Slot {
    private final SlotLens slot;
    private final int ordinal;
    private SlotAdapter nextSlot;
    private final ImmutableList<Inventory> slots;
    public int slotNumber = -1;

    public SlotAdapter(Fabric inventory, SlotLens lens, Inventory parent) {
        super(inventory, lens, parent);
        this.slot = lens;
        this.ordinal = lens.getOrdinal(inventory);
        this.slots = ImmutableList.of((Object)this);
        this.slotNumber = this.ordinal;
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    @Override
    public int getStackSize() {
        return this.slot.getStack(this.bridge$getFabric()).func_190916_E();
    }

    @Override
    public <T extends Inventory> Iterable<T> slots() {
        return this.slots;
    }

    @Override
    public <T extends Inventory> T first() {
        return (T)this;
    }

    @Override
    public Optional<ItemStack> poll() {
        net.minecraft.item.ItemStack stack = this.bridge$getFabric().fabric$getStack(this.ordinal);
        if (stack.func_190926_b()) {
            return Optional.empty();
        }
        this.bridge$getFabric().fabric$setStack(this.ordinal, net.minecraft.item.ItemStack.field_190927_a);
        return Optional.of(ItemStackUtil.fromNative(stack));
    }

    @Override
    public Optional<ItemStack> peek() {
        net.minecraft.item.ItemStack stack = this.slot.getStack(this.bridge$getFabric());
        if (stack.func_190926_b()) {
            return Optional.empty();
        }
        return ItemStackUtil.cloneDefensiveOptional(stack);
    }

    @Override
    public InventoryTransactionResult offer(ItemStack stack) {
        InventoryTransactionResult.Builder result = InventoryTransactionResult.builder().type(InventoryTransactionResult.Type.SUCCESS);
        net.minecraft.item.ItemStack nativeStack = ItemStackUtil.toNative(stack);
        int maxStackSize = this.slot.getMaxStackSize(this.bridge$getFabric());
        int remaining = stack.getQuantity();
        net.minecraft.item.ItemStack old = this.slot.getStack(this.bridge$getFabric());
        int push = Math.min(remaining, maxStackSize);
        if (old.func_190926_b() && this.slot.setStack(this.bridge$getFabric(), ItemStackUtil.cloneDefensiveNative(nativeStack, push))) {
            remaining -= push;
        } else if (!old.func_190926_b() && ItemStackUtil.compareIgnoreQuantity(old, stack)) {
            this.bridge$getFabric().fabric$markDirty();
            push = Math.max(Math.min(maxStackSize - old.func_190916_E(), remaining), 0);
            old.func_190920_e(old.func_190916_E() + push);
            remaining -= push;
        }
        if (remaining == stack.getQuantity()) {
            result.reject(ItemStackUtil.cloneDefensive(nativeStack));
        } else {
            stack.setQuantity(remaining);
        }
        return result.build();
    }

    @Override
    public boolean canFit(ItemStack stack) {
        if (stack.isEmpty()) {
            return true;
        }
        net.minecraft.item.ItemStack old = this.slot.getStack(this.bridge$getFabric());
        if (old.func_190926_b()) {
            return this.getMaxStackSize() >= stack.getQuantity();
        }
        return ItemStackUtil.compareIgnoreQuantity(old, stack) && this.getMaxStackSize() - old.func_190916_E() >= stack.getQuantity();
    }

    @Override
    public InventoryTransactionResult set(ItemStack stack) {
        InventoryTransactionResult.Builder result = InventoryTransactionResult.builder().type(InventoryTransactionResult.Type.SUCCESS);
        net.minecraft.item.ItemStack nativeStack = ItemStackUtil.toNative(stack);
        net.minecraft.item.ItemStack old = this.slot.getStack(this.bridge$getFabric());
        if (stack.getType() == ItemTypes.NONE) {
            this.clear();
            return result.replace(ItemStackUtil.fromNative(old)).build();
        }
        int remaining = stack.getQuantity();
        int push = Math.min(remaining, this.slot.getMaxStackSize(this.bridge$getFabric()));
        if (this.slot.setStack(this.bridge$getFabric(), ItemStackUtil.cloneDefensiveNative(nativeStack, push))) {
            result.replace(ItemStackUtil.fromNative(old));
            remaining -= push;
        }
        if (remaining > 0) {
            result.reject(ItemStackUtil.cloneDefensive(nativeStack, remaining));
        }
        return result.build();
    }

    @Override
    public void clear() {
        this.slot.setStack(this.bridge$getFabric(), net.minecraft.item.ItemStack.field_190927_a);
    }

    @Override
    public int size() {
        return !this.slot.getStack(this.bridge$getFabric()).func_190926_b() ? 1 : 0;
    }

    @Override
    public int totalItems() {
        return this.slot.getStack(this.bridge$getFabric()).func_190916_E();
    }

    @Override
    public int capacity() {
        return 1;
    }

    @Override
    public boolean hasChildren() {
        return false;
    }

    @Override
    public boolean contains(ItemStack stack) {
        net.minecraft.item.ItemStack slotStack = this.slot.getStack(this.bridge$getFabric());
        return slotStack.func_190926_b() ? ItemStackUtil.toNative(stack).func_190926_b() : ItemStackUtil.compareIgnoreQuantity(slotStack, stack) && slotStack.func_190916_E() >= stack.getQuantity();
    }

    @Override
    public boolean containsAny(ItemStack stack) {
        net.minecraft.item.ItemStack slotStack = this.slot.getStack(this.bridge$getFabric());
        return slotStack.func_190926_b() ? ItemStackUtil.toNative(stack).func_190926_b() : ItemStackUtil.compareIgnoreQuantity(slotStack, stack);
    }

    @Override
    public boolean contains(ItemType type) {
        net.minecraft.item.ItemStack slotStack = this.slot.getStack(this.bridge$getFabric());
        return slotStack.func_190926_b() ? type == null || type == ItemTypes.AIR : slotStack.func_77973_b().equals(type);
    }

    @Override
    public Slot transform(Slot.Type type) {
        switch (type) {
            case INVENTORY: {
                if (this.bridge$getFabric() instanceof net.minecraft.inventory.Slot) {
                    return (Slot)((Object)this.bridge$getFabric());
                }
                if (this.bridge$getFabric() instanceof Container) {
                    return (Slot)((Container)this.bridge$getFabric()).func_75139_a(this.slotNumber);
                }
                return this;
            }
        }
        return this;
    }

    @Override
    public Slot transform() {
        return this.transform(Slot.Type.INVENTORY);
    }

    @Override
    public Iterator<Inventory> iterator() {
        return new Iterator<Inventory>(){
            private boolean iterated = false;

            @Override
            public boolean hasNext() {
                return !this.iterated;
            }

            @Override
            public Inventory next() {
                if (this.iterated) {
                    throw new NoSuchElementException("Iterator is consumed");
                }
                this.iterated = true;
                return SlotAdapter.this;
            }
        };
    }
}

