/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.recipe.crafting;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.chars.Char2ObjectArrayMap;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.recipe.crafting.ShapedCraftingRecipe;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.text.translation.Translation;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.common.item.inventory.util.ItemStackUtil;
import org.spongepowered.common.item.recipe.crafting.IngredientUtil;
import org.spongepowered.common.item.recipe.crafting.SpongeShapedRecipe;
import org.spongepowered.common.mixin.core.item.crafting.ShapedRecipesAccessor;
import org.spongepowered.common.util.SpongeCatalogBuilder;

@NonnullByDefault
public final class SpongeShapedCraftingRecipeBuilder
extends SpongeCatalogBuilder<ShapedCraftingRecipe, ShapedCraftingRecipe.Builder>
implements ShapedCraftingRecipe.Builder,
ShapedCraftingRecipe.Builder.AisleStep.ResultStep,
ShapedCraftingRecipe.Builder.RowsStep.ResultStep,
ShapedCraftingRecipe.Builder.EndStep {
    private final List<String> aisle = Lists.newArrayList();
    private final Map<Character, org.spongepowered.api.item.recipe.crafting.Ingredient> ingredientMap = new Char2ObjectArrayMap();
    private ItemStack result = ItemStack.empty();
    private String groupName = "";

    @Override
    public ShapedCraftingRecipe.Builder.EndStep group(@Nullable String name) {
        this.groupName = Strings.nullToEmpty((String)name);
        return this;
    }

    @Override
    public ShapedCraftingRecipe.Builder.EndStep id(String id) {
        return (ShapedCraftingRecipe.Builder.EndStep)super.id(id);
    }

    @Override
    public ShapedCraftingRecipe.Builder.EndStep name(String name) {
        return (ShapedCraftingRecipe.Builder.EndStep)super.name(name);
    }

    @Override
    public ShapedCraftingRecipe.Builder.EndStep name(Translation name) {
        return (ShapedCraftingRecipe.Builder.EndStep)super.name(name);
    }

    @Override
    public ShapedCraftingRecipe.Builder.AisleStep aisle(String ... aisle) {
        Preconditions.checkNotNull((Object)aisle, (Object)"aisle");
        this.aisle.clear();
        this.ingredientMap.clear();
        Collections.addAll(this.aisle, aisle);
        return this;
    }

    @Override
    public ShapedCraftingRecipe.Builder.AisleStep.ResultStep where(char symbol, org.spongepowered.api.item.recipe.crafting.Ingredient ingredient) throws IllegalArgumentException {
        if (this.aisle.stream().noneMatch(row -> row.indexOf(symbol) >= 0)) {
            throw new IllegalArgumentException("The symbol '" + symbol + "' is not defined in the aisle pattern.");
        }
        this.ingredientMap.put(Character.valueOf(symbol), ingredient == null ? org.spongepowered.api.item.recipe.crafting.Ingredient.NONE : ingredient);
        return this;
    }

    @Override
    public ShapedCraftingRecipe.Builder.AisleStep.ResultStep where(Map<Character, org.spongepowered.api.item.recipe.crafting.Ingredient> ingredientMap) throws IllegalArgumentException {
        for (Map.Entry<Character, org.spongepowered.api.item.recipe.crafting.Ingredient> entry : ingredientMap.entrySet()) {
            this.where(entry.getKey().charValue(), entry.getValue());
        }
        return this;
    }

    @Override
    public ShapedCraftingRecipe.Builder.RowsStep rows() {
        this.aisle.clear();
        this.ingredientMap.clear();
        return this;
    }

    @Override
    public ShapedCraftingRecipe.Builder.RowsStep.ResultStep row(int skip, org.spongepowered.api.item.recipe.crafting.Ingredient ... ingredients) {
        int columns = ingredients.length + skip;
        if (!this.aisle.isEmpty()) {
            Preconditions.checkState((this.aisle.get(0).length() == columns ? 1 : 0) != 0, (Object)"The rows have an inconsistent width.");
        }
        StringBuilder row = new StringBuilder();
        for (int i = 0; i < skip; ++i) {
            row.append(" ");
        }
        int key = 97 + columns * this.aisle.size();
        for (org.spongepowered.api.item.recipe.crafting.Ingredient ingredient : ingredients) {
            char character = (char)(++key);
            row.append(character);
            this.ingredientMap.put(Character.valueOf(character), ingredient);
        }
        this.aisle.add(row.toString());
        return this;
    }

    @Override
    public ShapedCraftingRecipe.Builder.EndStep result(ItemStack result) {
        Preconditions.checkNotNull((Object)result, (Object)"result");
        this.result = result.copy();
        return this;
    }

    @Override
    protected ShapedCraftingRecipe build(PluginContainer plugin, String id, Translation name) {
        Preconditions.checkState((!this.aisle.isEmpty() ? 1 : 0) != 0, (Object)"aisle has not been set");
        Preconditions.checkState((!this.ingredientMap.isEmpty() ? 1 : 0) != 0, (Object)"no ingredients set");
        Preconditions.checkState((!this.result.isEmpty() ? 1 : 0) != 0, (Object)"no result set");
        Iterator<String> aisleIterator = this.aisle.iterator();
        String aisleRow = aisleIterator.next();
        int width = aisleRow.length();
        int height = 1;
        Preconditions.checkState((width > 0 ? 1 : 0) != 0, (Object)"The aisle cannot be empty.");
        while (aisleIterator.hasNext()) {
            ++height;
            aisleRow = aisleIterator.next();
            Preconditions.checkState((aisleRow.length() == width ? 1 : 0) != 0, (Object)"The aisle has an inconsistent width.");
        }
        String[] keys = this.aisle.toArray(new String[this.aisle.size()]);
        Map<String, Ingredient> ingredientsMap = this.ingredientMap.entrySet().stream().collect(Collectors.toMap(e -> ((Character)e.getKey()).toString(), e -> IngredientUtil.toNative((org.spongepowered.api.item.recipe.crafting.Ingredient)e.getValue())));
        ingredientsMap.putIfAbsent(" ", Ingredient.field_193370_a);
        NonNullList<Ingredient> ingredients = ShapedRecipesAccessor.accessor$deserializeIngredients(keys, ingredientsMap, width, height);
        return (ShapedCraftingRecipe)((Object)new SpongeShapedRecipe(plugin.getId() + ':' + id, this.groupName, width, height, ingredients, ItemStackUtil.toNative(this.result)));
    }

    @Override
    public ShapedCraftingRecipe.Builder from(ShapedCraftingRecipe value) {
        this.aisle.clear();
        this.ingredientMap.clear();
        this.groupName = "";
        if (value instanceof ShapedRecipesAccessor) {
            this.groupName = ((ShapedRecipesAccessor)((Object)value)).accessor$getGroup();
        }
        if (value != null) {
            for (int y = 0; y < value.getHeight(); ++y) {
                String row = "";
                for (int x = 0; x < value.getWidth(); ++x) {
                    char symbol = (char)(97 + x + y * value.getWidth());
                    row = row + symbol;
                    org.spongepowered.api.item.recipe.crafting.Ingredient ingredient = value.getIngredient(x, y);
                    this.ingredientMap.put(Character.valueOf(symbol), ingredient);
                }
                this.aisle.add(row);
            }
            this.result = value.getExemplaryResult().createStack();
        } else {
            this.result = null;
        }
        super.reset();
        return this;
    }

    @Override
    public ShapedCraftingRecipe.Builder reset() {
        super.reset();
        this.aisle.clear();
        this.ingredientMap.clear();
        this.result = ItemStack.empty();
        this.groupName = "";
        return this;
    }
}

