/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry.type.item;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.util.ResourceLocation;
import org.spongepowered.api.item.enchantment.EnchantmentType;
import org.spongepowered.api.item.enchantment.EnchantmentTypes;
import org.spongepowered.api.registry.AlternateCatalogRegistryModule;
import org.spongepowered.api.registry.util.AdditionalRegistration;
import org.spongepowered.api.registry.util.RegisterCatalog;
import org.spongepowered.common.registry.SpongeAdditionalCatalogRegistryModule;

public final class EnchantmentRegistryModule
implements SpongeAdditionalCatalogRegistryModule<EnchantmentType>,
AlternateCatalogRegistryModule<EnchantmentType> {
    @RegisterCatalog(value=EnchantmentTypes.class)
    private final Map<String, EnchantmentType> enchantmentMappings = new HashMap<String, EnchantmentType>();

    public static EnchantmentRegistryModule getInstance() {
        return Holder.INSTANCE;
    }

    @Override
    public Optional<EnchantmentType> getById(String id) {
        Preconditions.checkNotNull((Object)id);
        if (!id.contains(":")) {
            id = "minecraft:" + id;
        }
        return Optional.ofNullable(this.enchantmentMappings.get(((String)Preconditions.checkNotNull((Object)id)).toLowerCase(Locale.ENGLISH)));
    }

    @Override
    public Collection<EnchantmentType> getAll() {
        return ImmutableList.copyOf(this.enchantmentMappings.values());
    }

    @Override
    public Map<String, EnchantmentType> provideCatalogMap() {
        HashMap<String, EnchantmentType> newMap = new HashMap<String, EnchantmentType>();
        for (Map.Entry<String, EnchantmentType> entry : this.enchantmentMappings.entrySet()) {
            newMap.put(entry.getKey().replace("minecraft:", ""), entry.getValue());
        }
        return newMap;
    }

    @Override
    public void registerDefaults() {
        for (ResourceLocation key : Enchantment.field_185264_b.func_148742_b()) {
            this.enchantmentMappings.put(key.toString(), (EnchantmentType)Enchantment.field_185264_b.func_82594_a((Object)key));
        }
    }

    @AdditionalRegistration
    public void registerAdditional() {
        for (ResourceLocation key : Enchantment.field_185264_b.func_148742_b()) {
            Enchantment enchantment = (Enchantment)Enchantment.field_185264_b.func_82594_a((Object)key);
            if (enchantment == null || this.enchantmentMappings.containsValue(enchantment)) continue;
            String name = enchantment.func_77320_a().replace("enchantment.", "");
            this.enchantmentMappings.put(name.toLowerCase(Locale.ENGLISH), (EnchantmentType)enchantment);
        }
    }

    EnchantmentRegistryModule() {
    }

    @Override
    public boolean allowsApiRegistration() {
        return false;
    }

    @Override
    public void registerAdditionalCatalog(EnchantmentType extraCatalog) {
        Preconditions.checkNotNull((Object)extraCatalog, (Object)"EnchantmentType cannot be null!");
        this.enchantmentMappings.put(extraCatalog.getId(), extraCatalog);
    }

    public void registerFromGameData(String s, EnchantmentType obj) {
        Preconditions.checkNotNull((Object)obj, (Object)"EnchantmentType cannot be null!");
        this.enchantmentMappings.put(s, obj);
    }

    static final class Holder {
        static final EnchantmentRegistryModule INSTANCE = new EnchantmentRegistryModule();

        Holder() {
        }
    }
}

