/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.mod.mixin.core.common.world;

import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.nio.file.Path;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.DimensionType;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldProviderEnd;
import net.minecraft.world.WorldProviderHell;
import net.minecraft.world.WorldProviderSurface;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.SaveHandler;
import net.minecraftforge.common.network.ForgeMessage;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.FMLEmbeddedChannel;
import net.minecraftforge.fml.common.network.FMLOutboundHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.relauncher.Side;
import org.spongepowered.api.GameState;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.world.storage.WorldProperties;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.bridge.entity.player.EntityPlayerMPBridge;
import org.spongepowered.common.world.WorldManager;

@Mixin(value={WorldManager.class}, priority=999, remap=false)
public abstract class WorldManagerMixin_Forge {
    @Shadow
    @Final
    private static Int2ObjectMap<DimensionType> dimensionTypeByTypeId;
    @Shadow
    @Final
    private static Int2ObjectMap<DimensionType> dimensionTypeByDimensionId;
    @Shadow
    @Final
    private static Int2ObjectMap<Path> dimensionPathByDimensionId;
    @Shadow
    @Final
    private static Int2ObjectOpenHashMap<WorldServer> worldByDimensionId;
    @Shadow
    @Final
    private static Map<String, WorldProperties> worldPropertiesByFolderName;
    @Shadow
    @Final
    private static Map<UUID, WorldProperties> worldPropertiesByWorldUuid;
    @Shadow
    @Final
    private static Map<Integer, String> worldFolderByDimensionId;
    @Shadow
    @Final
    private static BiMap<String, UUID> worldUuidByFolderName;
    @Shadow
    @Final
    private static IntSet usedDimensionIds;

    @Overwrite
    public static Optional<Path> getCurrentSavesDirectory() {
        Optional<WorldServer> optWorldServer = WorldManager.getWorldByDimensionId(0);
        if (optWorldServer.isPresent()) {
            return Optional.of(optWorldServer.get().func_72860_G().func_75765_b().toPath());
        }
        if (Sponge.getPlatform().getType().isClient()) {
            return Optional.ofNullable(FMLCommonHandler.instance().getSavesDirectory().toPath());
        }
        if (SpongeImpl.getGame().getState().ordinal() >= GameState.SERVER_ABOUT_TO_START.ordinal()) {
            SaveHandler saveHandler = (SaveHandler)SpongeImpl.getServer().func_71254_M().func_75804_a(SpongeImpl.getServer().func_71270_I(), false);
            return Optional.of(saveHandler.func_75765_b().toPath());
        }
        return Optional.empty();
    }

    @Overwrite
    public static void sendDimensionRegistration(EntityPlayerMP player, WorldProvider provider) {
        if (((EntityPlayerMPBridge)player).bridge$usesCustomClient()) {
            boolean modDimension;
            int dimension = provider.getDimension();
            boolean vanillaProvider = provider.getClass() == WorldProviderSurface.class || provider.getClass() == WorldProviderHell.class || provider.getClass() == WorldProviderEnd.class;
            boolean bl = modDimension = dimension < -1 || dimension > 1;
            if (vanillaProvider && modDimension) {
                FMLEmbeddedChannel serverChannel = NetworkRegistry.INSTANCE.getChannel("FORGE", Side.SERVER);
                serverChannel.attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.PLAYER);
                serverChannel.attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)player);
                serverChannel.writeOutbound(new Object[]{new ForgeMessage.DimensionRegisterMessage(dimension, provider.func_186058_p().name())});
            }
        }
    }

    @Nullable
    @Overwrite
    private static Path getWorldFolder(DimensionType dimensionType, int dimensionId) {
        Path path = (Path)dimensionPathByDimensionId.get(dimensionId);
        if (path != null) {
            return path;
        }
        if (dimensionType == null) {
            return null;
        }
        try {
            WorldProvider provider = dimensionType.func_186070_d();
            provider.setDimension(dimensionId);
            String worldFolder = provider.getSaveFolder();
            path = WorldManager.getCurrentSavesDirectory().get().resolve(worldFolder);
            WorldManager.registerDimensionPath(dimensionId, path);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return path;
    }

    @Overwrite
    public static void registerDimensionType(DimensionType type) {
        Preconditions.checkNotNull((Object)type);
        WorldManager.registerDimensionType(type.func_186068_a(), type);
    }

    @Overwrite
    public static void registerDimension(int dimensionId, DimensionType type) {
        Preconditions.checkNotNull((Object)type);
        if (dimensionTypeByDimensionId.containsKey(dimensionId)) {
            return;
        }
        dimensionTypeByDimensionId.put(dimensionId, (Object)type);
        dimensionTypeByTypeId.put(dimensionId, (Object)type);
        if (dimensionId >= 0) {
            usedDimensionIds.add(dimensionId);
        }
    }

    @Overwrite
    public static void unregisterDimension(int dimensionId) {
        String worldFolder;
        dimensionTypeByDimensionId.remove(dimensionId);
        dimensionTypeByTypeId.remove(dimensionId);
        dimensionPathByDimensionId.remove(dimensionId);
        if (dimensionId >= 0) {
            usedDimensionIds.remove(dimensionId);
        }
        if ((worldFolder = worldFolderByDimensionId.get(dimensionId)) != null) {
            worldPropertiesByFolderName.remove(worldFolder);
            UUID worldUniqueId = (UUID)worldUuidByFolderName.get((Object)worldFolder);
            if (worldUniqueId != null) {
                worldPropertiesByWorldUuid.remove(worldUniqueId);
            }
            worldUuidByFolderName.remove((Object)worldFolder);
            worldPropertiesByFolderName.remove(worldFolder);
        }
        worldByDimensionId.remove(dimensionId);
        worldFolderByDimensionId.remove(dimensionId);
    }
}

