/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.core.executor;

import dan200.computercraft.api.lua.LuaException;
import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.squiddev.plethora.api.method.MethodResult;
import org.squiddev.plethora.core.PlethoraCore;

public class Task {
    private volatile boolean done = false;
    private Callable<MethodResult> callback;
    private MethodResult.Resolver resolver;
    private boolean resolved;
    Object[] result;
    LuaException error;

    Task(Callable<MethodResult> callback, MethodResult.Resolver resolver) {
        this.callback = callback;
        this.resolver = resolver;
    }

    private void finish(@Nullable Object[] result) {
        this.done = true;
        this.result = result;
        this.whenDone();
    }

    private void finish(@Nonnull LuaException error) {
        this.done = true;
        this.error = error;
        this.whenDone();
    }

    public boolean update() {
        while (!this.done && (this.resolved || (this.resolved = this.resolver.update()) && this.canWork())) {
            long start = System.nanoTime();
            try {
                MethodResult next = this.callback.call();
                if (next.isFinal()) {
                    this.finish(next.getResult());
                    boolean bl = true;
                    return bl;
                }
                this.resolver = next.getResolver();
                this.resolved = false;
                this.callback = next.getCallback();
            }
            catch (LuaException e) {
                this.finish(e);
                boolean bl = true;
                return bl;
            }
            catch (Exception | LinkageError | VirtualMachineError e) {
                this.finish(new LuaException("Java Exception Thrown: " + e));
                PlethoraCore.LOG.error("Unexpected error", e);
                boolean bl = true;
                return bl;
            }
            catch (Error e) {
                this.finish(new LuaException("Java Exception Thrown: " + e));
                PlethoraCore.LOG.error("Unexpected error", (Throwable)e);
                throw e;
            }
            finally {
                this.submitTiming(System.nanoTime() - start);
            }
        }
        return this.done;
    }

    final void cancel() {
        this.done = true;
    }

    final boolean isDone() {
        return this.done;
    }

    void whenDone() {
    }

    void submitTiming(long time) {
    }

    boolean canWork() {
        return true;
    }
}

