/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.gameplay.modules.glasses;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import org.squiddev.plethora.gameplay.modules.glasses.BaseObject;
import org.squiddev.plethora.gameplay.modules.glasses.CanvasClient;
import org.squiddev.plethora.gameplay.modules.glasses.CanvasHandler;
import org.squiddev.plethora.gameplay.modules.glasses.objects.ObjectRegistry;
import org.squiddev.plethora.gameplay.registry.BasicMessage;

public class MessageCanvasUpdate
implements BasicMessage {
    private int canvasId;
    private List<BaseObject> changed;
    private int[] removed;

    public MessageCanvasUpdate(int canvasId, List<BaseObject> changed, int[] removed) {
        this.canvasId = canvasId;
        this.changed = changed;
        this.removed = removed;
    }

    public MessageCanvasUpdate() {
    }

    public void fromBytes(ByteBuf buf) {
        this.canvasId = buf.readInt();
        int changedLength = buf.readInt();
        this.changed = new ArrayList<BaseObject>(changedLength);
        ArrayList<BaseObject> changed = this.changed;
        for (int i = 0; i < changedLength; ++i) {
            changed.add(ObjectRegistry.read(buf));
        }
        changed.sort(BaseObject.SORTING_ORDER);
        int removedLength = buf.readInt();
        this.removed = new int[removedLength];
        int[] removed = this.removed;
        for (int i = 0; i < removedLength; ++i) {
            removed[i] = buf.readInt();
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.canvasId);
        buf.writeInt(this.changed.size());
        for (BaseObject object : this.changed) {
            ObjectRegistry.write(buf, object);
        }
        buf.writeInt(this.removed.length);
        for (Object id : (Object)this.removed) {
            buf.writeInt((int)id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onMessage(MessageContext context) {
        CanvasClient canvas = CanvasHandler.getClient(this.canvasId);
        if (canvas == null) {
            return;
        }
        CanvasClient canvasClient = canvas;
        synchronized (canvasClient) {
            for (BaseObject obj : this.changed) {
                canvas.updateObject(obj);
            }
            for (Object id : (Object)this.removed) {
                canvas.remove((int)id);
            }
        }
    }
}

