/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.gameplay.modules.glasses.objects.object2d;

import com.google.common.base.Objects;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.ints.IntSet;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.squiddev.plethora.gameplay.modules.glasses.BaseObject;
import org.squiddev.plethora.gameplay.modules.glasses.CanvasClient;
import org.squiddev.plethora.gameplay.modules.glasses.objects.ObjectGroup;
import org.squiddev.plethora.gameplay.modules.glasses.objects.object2d.Positionable2D;
import org.squiddev.plethora.utils.ByteBufUtils;
import org.squiddev.plethora.utils.Vec2d;

public class ObjectGroup2D
extends BaseObject
implements ObjectGroup.Group2D,
Positionable2D {
    private Vec2d position = Vec2d.ZERO;

    public ObjectGroup2D(int id, int parent) {
        super(id, parent, (byte)8);
    }

    @Override
    @Nonnull
    public Vec2d getPosition() {
        return this.position;
    }

    @Override
    public void setPosition(@Nonnull Vec2d position) {
        if (!Objects.equal((Object)this.position, (Object)position)) {
            this.position = position;
            this.setDirty();
        }
    }

    @Override
    public void writeInitial(ByteBuf buf) {
        ByteBufUtils.writeVec2d(buf, this.position);
    }

    @Override
    public void readInitial(ByteBuf buf) {
        this.position = ByteBufUtils.readVec2d(buf);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void draw(CanvasClient canvas) {
        IntSet children = canvas.getChildren(this.id());
        if (children == null) {
            return;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)this.position.x, (double)this.position.y, (double)0.0);
        canvas.drawChildren(children.iterator());
        GlStateManager.func_179121_F();
    }
}

