/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.gameplay.neural;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import dan200.computercraft.ComputerCraft;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IRecipeFactory;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.oredict.ShapedOreRecipe;
import org.squiddev.plethora.gameplay.ItemBase;

public class CraftingNeuralInterface
extends ShapedOreRecipe {
    public CraftingNeuralInterface(ResourceLocation group, @Nonnull ItemStack result, CraftingHelper.ShapedPrimer primer) {
        super(group, result, primer);
    }

    @Nonnull
    public ItemStack func_77572_b(@Nonnull InventoryCrafting inv) {
        NBTTagCompound fromTag;
        ItemStack output = this.func_77571_b().func_77946_l();
        ItemStack old = inv.func_70463_b(1, 1);
        int id = ComputerCraft.Items.pocketComputer.getComputerID(old);
        String label = ComputerCraft.Items.pocketComputer.getLabel(old);
        NBTTagCompound tag = ItemBase.getTag(output);
        if (label != null) {
            output.func_151001_c(label);
        }
        if (id >= 0) {
            tag.func_74768_a("id", id);
        }
        if ((fromTag = old.func_77978_p()) != null && fromTag.func_74764_b("rom_id")) {
            tag.func_74782_a("rom_id", fromTag.func_74781_a("rom_id"));
        }
        return output;
    }

    public static class Factory
    implements IRecipeFactory {
        public IRecipe parse(JsonContext context, JsonObject json) {
            String group = JsonUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
            HashMap<Character, Ingredient> ingMap = new HashMap<Character, Ingredient>();
            for (Map.Entry entry : JsonUtils.func_152754_s((JsonObject)json, (String)"key").entrySet()) {
                if (((String)entry.getKey()).length() != 1) {
                    throw new JsonSyntaxException("Invalid key entry: '" + (String)entry.getKey() + "' is an invalid symbol (must be 1 character only).");
                }
                if (" ".equals(entry.getKey())) {
                    throw new JsonSyntaxException("Invalid key entry: ' ' is a reserved symbol.");
                }
                ingMap.put(Character.valueOf(((String)entry.getKey()).toCharArray()[0]), CraftingHelper.getIngredient((JsonElement)((JsonElement)entry.getValue()), (JsonContext)context));
            }
            ingMap.put(Character.valueOf(' '), Ingredient.field_193370_a);
            JsonArray patternJ = JsonUtils.func_151214_t((JsonObject)json, (String)"pattern");
            if (patternJ.size() == 0) {
                throw new JsonSyntaxException("Invalid pattern: empty pattern not allowed");
            }
            String[] pattern = new String[patternJ.size()];
            for (int x = 0; x < pattern.length; ++x) {
                String line = JsonUtils.func_151206_a((JsonElement)patternJ.get(x), (String)("pattern[" + x + "]"));
                if (x > 0 && pattern[0].length() != line.length()) {
                    throw new JsonSyntaxException("Invalid pattern: each row must  be the same width");
                }
                pattern[x] = line;
            }
            CraftingHelper.ShapedPrimer primer = new CraftingHelper.ShapedPrimer();
            primer.width = pattern[0].length();
            primer.height = pattern.length;
            primer.mirrored = JsonUtils.func_151209_a((JsonObject)json, (String)"mirrored", (boolean)true);
            primer.input = NonNullList.func_191197_a((int)(primer.width * primer.height), (Object)Ingredient.field_193370_a);
            HashSet keys = new HashSet(ingMap.keySet());
            keys.remove(Character.valueOf(' '));
            int x = 0;
            for (String line : pattern) {
                for (char chr : line.toCharArray()) {
                    Ingredient ing = (Ingredient)ingMap.get(Character.valueOf(chr));
                    if (ing == null) {
                        throw new JsonSyntaxException("Pattern references symbol '" + chr + "' but it's not defined in the key");
                    }
                    primer.input.set(x++, (Object)ing);
                    keys.remove(Character.valueOf(chr));
                }
            }
            if (!keys.isEmpty()) {
                throw new JsonSyntaxException("Key defines symbols that aren't used in pattern: " + keys);
            }
            ItemStack result = CraftingHelper.getItemStack((JsonObject)JsonUtils.func_152754_s((JsonObject)json, (String)"result"), (JsonContext)context);
            return new CraftingNeuralInterface(group.isEmpty() ? null : new ResourceLocation(group), result, primer);
        }
    }
}

