/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.integration;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCommandBlock;
import net.minecraft.block.BlockStructure;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import org.apache.commons.lang3.tuple.Pair;
import org.squiddev.plethora.api.method.MethodResult;

public final class PlayerInteractionHelpers {
    private PlayerInteractionHelpers() {
    }

    @Nonnull
    public static MethodResult use(@Nonnull EntityPlayerMP player, @Nonnull RayTraceResult hit, @Nonnull EnumHand hand, int duration) {
        EnumActionResult result;
        ItemStack stack = player.func_184586_b(hand);
        World world = player.func_130014_f_();
        switch (hit.field_72313_a) {
            case ENTITY: {
                Entity target = hit.field_72308_g;
                Vec3d vec3d = new Vec3d(hit.field_72307_f.field_72450_a - target.field_70165_t, hit.field_72307_f.field_72448_b - target.field_70163_u, hit.field_72307_f.field_72449_c - target.field_70161_v);
                EnumActionResult cancelResult = ForgeHooks.onInteractEntityAt((EntityPlayer)player, (Entity)target, (RayTraceResult)hit, (EnumHand)hand);
                if (cancelResult == null) {
                    cancelResult = target.func_184199_a((EntityPlayer)player, vec3d, hand);
                }
                if (cancelResult == EnumActionResult.SUCCESS) {
                    return MethodResult.result(true, "entity");
                }
                if (player.func_190775_a(target, hand) != EnumActionResult.SUCCESS) break;
                return MethodResult.result(true, "entity");
            }
            case BLOCK: {
                float hitZ;
                float hitY;
                BlockPos pos = hit.func_178782_a();
                if (world.func_175623_d(pos) || !world.func_175723_af().func_177746_a(pos)) break;
                float hitX = (float)hit.field_72307_f.field_72450_a - (float)pos.func_177958_n();
                EnumActionResult result2 = PlayerInteractionHelpers.rightClickBlock((EntityPlayer)player, world, stack, hand, pos, hit.field_178784_b, hitX, hitY = (float)hit.field_72307_f.field_72448_b - (float)pos.func_177956_o(), hitZ = (float)hit.field_72307_f.field_72449_c - (float)pos.func_177952_p());
                if (result2 == EnumActionResult.SUCCESS) {
                    return MethodResult.result(true, "block");
                }
                result2 = PlayerInteractionHelpers.rightClickBlock((EntityPlayer)player, world, stack, hand, pos, hit.field_178784_b.func_176734_d(), hitX, hitY, hitZ);
                if (result2 != EnumActionResult.SUCCESS) break;
                return MethodResult.result(true, "block");
            }
        }
        if (stack.func_190926_b() && hit.field_72313_a == RayTraceResult.Type.MISS) {
            ForgeHooks.onEmptyClick((EntityPlayer)player, (EnumHand)hand);
        }
        if (!stack.func_190926_b() && (result = player.field_71134_c.func_187250_a((EntityPlayer)player, world, stack, hand)) == EnumActionResult.SUCCESS) {
            ItemStack active = player.func_184607_cu();
            if (!active.func_190926_b()) {
                return MethodResult.delayed(duration, () -> {
                    if (player.func_184586_b(hand) == active && !active.func_190926_b() && (player.func_184607_cu() == active || player.func_184607_cu().func_190926_b())) {
                        if (!ForgeEventFactory.onUseItemStop((EntityLivingBase)player, (ItemStack)active, (int)duration)) {
                            active.func_77974_b(player.func_130014_f_(), (EntityLivingBase)player, active.func_77988_m() - duration);
                        }
                        player.func_184602_cy();
                        return MethodResult.result(true, "item");
                    }
                    return MethodResult.result((Object)false);
                });
            }
            return MethodResult.result(true, "item");
        }
        return MethodResult.result((Object)false);
    }

    private static EnumActionResult rightClickBlock(EntityPlayer player, World worldIn, ItemStack stack, EnumHand hand, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ) {
        Block block;
        boolean bypass;
        EnumActionResult result;
        double reachDist = player.func_110148_a(EntityPlayer.REACH_DISTANCE).func_111126_e();
        PlayerInteractEvent.RightClickBlock event = ForgeHooks.onRightClickBlock((EntityPlayer)player, (EnumHand)hand, (BlockPos)pos, (EnumFacing)facing, (Vec3d)ForgeHooks.rayTraceEyeHitVec((EntityLivingBase)player, (double)(reachDist + 1.0)));
        if (event.isCanceled()) {
            return event.getCancellationResult();
        }
        if (event.getUseItem() != Event.Result.DENY && (result = stack.onItemUseFirst(player, worldIn, pos, hand, facing, hitX, hitY, hitZ)) != EnumActionResult.PASS) {
            return result;
        }
        boolean bl = bypass = player.func_184614_ca().doesSneakBypassUse((IBlockAccess)worldIn, pos, player) && player.func_184592_cb().doesSneakBypassUse((IBlockAccess)worldIn, pos, player);
        if (!player.func_70093_af() || bypass || event.getUseBlock() == Event.Result.ALLOW) {
            IBlockState state = worldIn.func_180495_p(pos);
            if (event.getUseBlock() != Event.Result.DENY && state.func_177230_c().func_180639_a(worldIn, pos, state, player, hand, facing, hitX, hitY, hitZ)) {
                return EnumActionResult.SUCCESS;
            }
        }
        if (stack.func_190926_b() || player.func_184811_cZ().func_185141_a(stack.func_77973_b())) {
            return EnumActionResult.PASS;
        }
        if (stack.func_77973_b() instanceof ItemBlock && !player.func_189808_dh() && ((block = ((ItemBlock)stack.func_77973_b()).func_179223_d()) instanceof BlockCommandBlock || block instanceof BlockStructure)) {
            return EnumActionResult.FAIL;
        }
        if (event.getUseItem() == Event.Result.DENY) {
            return EnumActionResult.PASS;
        }
        ItemStack copyBeforeUse = stack.func_77946_l();
        EnumActionResult result2 = stack.func_179546_a(player, worldIn, pos, hand, facing, hitX, hitY, hitZ);
        if (stack.func_190926_b()) {
            ForgeEventFactory.onPlayerDestroyItem((EntityPlayer)player, (ItemStack)copyBeforeUse, (EnumHand)hand);
        }
        return result2;
    }

    public static Pair<Boolean, String> attack(@Nonnull EntityPlayerMP player, @Nullable Entity hitEntity) {
        if (hitEntity != null) {
            player.func_71059_n(hitEntity);
            return Pair.of((Object)true, (Object)"entity");
        }
        return Pair.of((Object)false, (Object)"Nothing to attack here");
    }
}

